/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import at.qubic.api.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Entity {
    private final byte[] publicKey;
    private final long incomingAmount;
    private final long outgoingAmount;
    private final int numberOfIncomingTransfers;
    private final int numberOfOutgoingTransfers;
    private final int latestIncomingTransferTick;
    private final int latestOutgoingTransferTick;
    private final int tick;
    private final int spectrumIndex;
    private final byte[][] spectrum;

    public static Entity fromBytes(byte[] input) {
        ByteBuffer buf = ByteBuffer.wrap(input);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        Entity entity = Entity.builder().publicKey(BufferUtil.getByteArray(buf, 32)).incomingAmount(buf.getLong()).outgoingAmount(buf.getLong()).numberOfIncomingTransfers(buf.getInt()).numberOfOutgoingTransfers(buf.getInt()).latestIncomingTransferTick(buf.getInt()).latestOutgoingTransferTick(buf.getInt()).tick(buf.getInt()).spectrumIndex(buf.getInt()).spectrum(Entity.getSpectrum(buf)).build();
        assert (buf.remaining() == 0);
        return entity;
    }

    public ByteBuffer toByteBuffer() {
        Objects.requireNonNull(this.publicKey);
        Objects.requireNonNull(this.spectrum);
        ByteBuffer buf = ByteBuffer.allocate(72 + this.spectrum.length * 32);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.publicKey);
        buf.putLong(this.incomingAmount);
        buf.putLong(this.outgoingAmount);
        buf.putInt(this.numberOfIncomingTransfers);
        buf.putInt(this.numberOfOutgoingTransfers);
        buf.putInt(this.latestIncomingTransferTick);
        buf.putInt(this.latestOutgoingTransferTick);
        buf.putInt(this.tick);
        buf.putInt(this.spectrumIndex);
        for (byte[] hash : this.spectrum) {
            buf.put(hash);
        }
        return buf;
    }

    private static byte[][] getSpectrum(ByteBuffer buf) {
        byte[][] spectrum;
        for (byte[] bytes : spectrum = new byte[24][32]) {
            buf.get(bytes);
        }
        return spectrum;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("publicKey", this.publicKey == null ? null : Hex.encodeHexString((byte[])this.publicKey)).append("incomingAmount", (Object)Long.toUnsignedString(this.incomingAmount)).append("outgoingAmount", (Object)Long.toUnsignedString(this.outgoingAmount)).append("numberOfIncomingTransfers", Integer.toUnsignedLong(this.numberOfIncomingTransfers)).append("numberOfOutgoingTransfers", Integer.toUnsignedLong(this.numberOfOutgoingTransfers)).append("latestIncomingTransferTick", Integer.toUnsignedLong(this.latestIncomingTransferTick)).append("latestOutgoingTransferTick", Integer.toUnsignedLong(this.latestOutgoingTransferTick)).append("tick", Integer.toUnsignedLong(this.tick)).build();
    }

    @Generated
    Entity(byte[] publicKey, long incomingAmount, long outgoingAmount, int numberOfIncomingTransfers, int numberOfOutgoingTransfers, int latestIncomingTransferTick, int latestOutgoingTransferTick, int tick, int spectrumIndex, byte[][] spectrum) {
        this.publicKey = publicKey;
        this.incomingAmount = incomingAmount;
        this.outgoingAmount = outgoingAmount;
        this.numberOfIncomingTransfers = numberOfIncomingTransfers;
        this.numberOfOutgoingTransfers = numberOfOutgoingTransfers;
        this.latestIncomingTransferTick = latestIncomingTransferTick;
        this.latestOutgoingTransferTick = latestOutgoingTransferTick;
        this.tick = tick;
        this.spectrumIndex = spectrumIndex;
        this.spectrum = spectrum;
    }

    @Generated
    public static EntityBuilder builder() {
        return new EntityBuilder();
    }

    @Generated
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public long getIncomingAmount() {
        return this.incomingAmount;
    }

    @Generated
    public long getOutgoingAmount() {
        return this.outgoingAmount;
    }

    @Generated
    public int getNumberOfIncomingTransfers() {
        return this.numberOfIncomingTransfers;
    }

    @Generated
    public int getNumberOfOutgoingTransfers() {
        return this.numberOfOutgoingTransfers;
    }

    @Generated
    public int getLatestIncomingTransferTick() {
        return this.latestIncomingTransferTick;
    }

    @Generated
    public int getLatestOutgoingTransferTick() {
        return this.latestOutgoingTransferTick;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    @Generated
    public int getSpectrumIndex() {
        return this.spectrumIndex;
    }

    @Generated
    public byte[][] getSpectrum() {
        return this.spectrum;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIncomingAmount() != other.getIncomingAmount()) {
            return false;
        }
        if (this.getOutgoingAmount() != other.getOutgoingAmount()) {
            return false;
        }
        if (this.getNumberOfIncomingTransfers() != other.getNumberOfIncomingTransfers()) {
            return false;
        }
        if (this.getNumberOfOutgoingTransfers() != other.getNumberOfOutgoingTransfers()) {
            return false;
        }
        if (this.getLatestIncomingTransferTick() != other.getLatestIncomingTransferTick()) {
            return false;
        }
        if (this.getLatestOutgoingTransferTick() != other.getLatestOutgoingTransferTick()) {
            return false;
        }
        if (this.getTick() != other.getTick()) {
            return false;
        }
        if (this.getSpectrumIndex() != other.getSpectrumIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getSpectrum(), (Object[])other.getSpectrum());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Entity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $incomingAmount = this.getIncomingAmount();
        result = result * 59 + (int)($incomingAmount >>> 32 ^ $incomingAmount);
        long $outgoingAmount = this.getOutgoingAmount();
        result = result * 59 + (int)($outgoingAmount >>> 32 ^ $outgoingAmount);
        result = result * 59 + this.getNumberOfIncomingTransfers();
        result = result * 59 + this.getNumberOfOutgoingTransfers();
        result = result * 59 + this.getLatestIncomingTransferTick();
        result = result * 59 + this.getLatestOutgoingTransferTick();
        result = result * 59 + this.getTick();
        result = result * 59 + this.getSpectrumIndex();
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getSpectrum());
        return result;
    }

    @Generated
    public static class EntityBuilder {
        @Generated
        private byte[] publicKey;
        @Generated
        private long incomingAmount;
        @Generated
        private long outgoingAmount;
        @Generated
        private int numberOfIncomingTransfers;
        @Generated
        private int numberOfOutgoingTransfers;
        @Generated
        private int latestIncomingTransferTick;
        @Generated
        private int latestOutgoingTransferTick;
        @Generated
        private int tick;
        @Generated
        private int spectrumIndex;
        @Generated
        private byte[][] spectrum;

        @Generated
        EntityBuilder() {
        }

        @Generated
        public EntityBuilder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public EntityBuilder incomingAmount(long incomingAmount) {
            this.incomingAmount = incomingAmount;
            return this;
        }

        @Generated
        public EntityBuilder outgoingAmount(long outgoingAmount) {
            this.outgoingAmount = outgoingAmount;
            return this;
        }

        @Generated
        public EntityBuilder numberOfIncomingTransfers(int numberOfIncomingTransfers) {
            this.numberOfIncomingTransfers = numberOfIncomingTransfers;
            return this;
        }

        @Generated
        public EntityBuilder numberOfOutgoingTransfers(int numberOfOutgoingTransfers) {
            this.numberOfOutgoingTransfers = numberOfOutgoingTransfers;
            return this;
        }

        @Generated
        public EntityBuilder latestIncomingTransferTick(int latestIncomingTransferTick) {
            this.latestIncomingTransferTick = latestIncomingTransferTick;
            return this;
        }

        @Generated
        public EntityBuilder latestOutgoingTransferTick(int latestOutgoingTransferTick) {
            this.latestOutgoingTransferTick = latestOutgoingTransferTick;
            return this;
        }

        @Generated
        public EntityBuilder tick(int tick) {
            this.tick = tick;
            return this;
        }

        @Generated
        public EntityBuilder spectrumIndex(int spectrumIndex) {
            this.spectrumIndex = spectrumIndex;
            return this;
        }

        @Generated
        public EntityBuilder spectrum(byte[][] spectrum) {
            this.spectrum = spectrum;
            return this;
        }

        @Generated
        public Entity build() {
            return new Entity(this.publicKey, this.incomingAmount, this.outgoingAmount, this.numberOfIncomingTransfers, this.numberOfOutgoingTransfers, this.latestIncomingTransferTick, this.latestOutgoingTransferTick, this.tick, this.spectrumIndex, this.spectrum);
        }

        @Generated
        public String toString() {
            return "Entity.EntityBuilder(publicKey=" + Arrays.toString(this.publicKey) + ", incomingAmount=" + this.incomingAmount + ", outgoingAmount=" + this.outgoingAmount + ", numberOfIncomingTransfers=" + this.numberOfIncomingTransfers + ", numberOfOutgoingTransfers=" + this.numberOfOutgoingTransfers + ", latestIncomingTransferTick=" + this.latestIncomingTransferTick + ", latestOutgoingTransferTick=" + this.latestOutgoingTransferTick + ", tick=" + this.tick + ", spectrumIndex=" + this.spectrumIndex + ", spectrum=" + Arrays.deepToString((Object[])this.spectrum) + ")";
        }
    }
}

