/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ExchangePublicPeers {
    private final String[] peers;

    public static ExchangePublicPeers fromBytes(byte[] input) {
        ByteBuffer buf = ByteBuffer.wrap(input);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        String[] peers = new String[4];
        for (int i = 0; i < peers.length; ++i) {
            peers[i] = String.format("%d.%d.%d.%d", Byte.toUnsignedInt(buf.get()), Byte.toUnsignedInt(buf.get()), Byte.toUnsignedInt(buf.get()), Byte.toUnsignedInt(buf.get()));
        }
        return ExchangePublicPeers.builder().peers(peers).build();
    }

    public ByteBuffer toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(64);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (String peer : this.peers) {
            byte[] ip = this.ipStringToInts(peer);
            buf.put(ip[0]);
            buf.put(ip[1]);
            buf.put(ip[2]);
            buf.put(ip[3]);
        }
        return buf;
    }

    byte[] ipStringToInts(String ip) {
        Byte[] numbers = Arrays.stream(StringUtils.split((String)ip, (String)".")).map(s -> (byte)Integer.parseInt(s)).toList().toArray(new Byte[0]);
        return ArrayUtils.toPrimitive((Byte[])numbers);
    }

    @Generated
    ExchangePublicPeers(String[] peers) {
        this.peers = peers;
    }

    @Generated
    public static ExchangePublicPeersBuilder builder() {
        return new ExchangePublicPeersBuilder();
    }

    @Generated
    public String[] getPeers() {
        return this.peers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExchangePublicPeers)) {
            return false;
        }
        ExchangePublicPeers other = (ExchangePublicPeers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getPeers(), other.getPeers());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExchangePublicPeers;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getPeers());
        return result;
    }

    @Generated
    public static class ExchangePublicPeersBuilder {
        @Generated
        private String[] peers;

        @Generated
        ExchangePublicPeersBuilder() {
        }

        @Generated
        public ExchangePublicPeersBuilder peers(String[] peers) {
            this.peers = peers;
            return this;
        }

        @Generated
        public ExchangePublicPeers build() {
            return new ExchangePublicPeers(this.peers);
        }

        @Generated
        public String toString() {
            return "ExchangePublicPeers.ExchangePublicPeersBuilder(peers=" + Arrays.deepToString(this.peers) + ")";
        }
    }
}

