/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import at.qubic.api.domain.std.response.AssetIssuance;
import at.qubic.api.domain.std.response.AssetOwnership;
import at.qubic.api.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;

public class RespondOwnedAssets {
    private final AssetOwnership asset;
    private final AssetIssuance issuanceAsset;
    private final int tick;
    private final int universeIndex;
    private final byte[][] siblings;

    public static RespondOwnedAssets fromBytes(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        AssetOwnership assetOwnership = AssetOwnership.fromByteBuffer(buf);
        AssetIssuance assetIssuance = AssetIssuance.fromByteBuffer(buf);
        int tick = buf.getInt();
        int universeIndex = buf.getInt();
        RespondOwnedAssets roa = RespondOwnedAssets.builder().asset(assetOwnership).issuanceAsset(assetIssuance).tick(tick).universeIndex(universeIndex).siblings(BufferUtil.getByteArrays(buf, 24, 32)).build();
        assert (buf.remaining() == 0) : buf.remaining();
        return roa;
    }

    @Generated
    private static byte[][] $default$siblings() {
        return new byte[24][32];
    }

    @Generated
    RespondOwnedAssets(AssetOwnership asset, AssetIssuance issuanceAsset, int tick, int universeIndex, byte[][] siblings) {
        this.asset = asset;
        this.issuanceAsset = issuanceAsset;
        this.tick = tick;
        this.universeIndex = universeIndex;
        this.siblings = siblings;
    }

    @Generated
    public static RespondOwnedAssetsBuilder builder() {
        return new RespondOwnedAssetsBuilder();
    }

    @Generated
    public AssetOwnership getAsset() {
        return this.asset;
    }

    @Generated
    public AssetIssuance getIssuanceAsset() {
        return this.issuanceAsset;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    @Generated
    public int getUniverseIndex() {
        return this.universeIndex;
    }

    @Generated
    public byte[][] getSiblings() {
        return this.siblings;
    }

    @Generated
    public String toString() {
        return "RespondOwnedAssets(asset=" + String.valueOf(this.getAsset()) + ", issuanceAsset=" + String.valueOf(this.getIssuanceAsset()) + ", tick=" + this.getTick() + ", universeIndex=" + this.getUniverseIndex() + ")";
    }

    @Generated
    public static class RespondOwnedAssetsBuilder {
        @Generated
        private AssetOwnership asset;
        @Generated
        private AssetIssuance issuanceAsset;
        @Generated
        private int tick;
        @Generated
        private int universeIndex;
        @Generated
        private boolean siblings$set;
        @Generated
        private byte[][] siblings$value;

        @Generated
        RespondOwnedAssetsBuilder() {
        }

        @Generated
        public RespondOwnedAssetsBuilder asset(AssetOwnership asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public RespondOwnedAssetsBuilder issuanceAsset(AssetIssuance issuanceAsset) {
            this.issuanceAsset = issuanceAsset;
            return this;
        }

        @Generated
        public RespondOwnedAssetsBuilder tick(int tick) {
            this.tick = tick;
            return this;
        }

        @Generated
        public RespondOwnedAssetsBuilder universeIndex(int universeIndex) {
            this.universeIndex = universeIndex;
            return this;
        }

        @Generated
        public RespondOwnedAssetsBuilder siblings(byte[][] siblings) {
            this.siblings$value = siblings;
            this.siblings$set = true;
            return this;
        }

        @Generated
        public RespondOwnedAssets build() {
            byte[][] siblings$value = this.siblings$value;
            if (!this.siblings$set) {
                siblings$value = RespondOwnedAssets.$default$siblings();
            }
            return new RespondOwnedAssets(this.asset, this.issuanceAsset, this.tick, this.universeIndex, siblings$value);
        }

        @Generated
        public String toString() {
            return "RespondOwnedAssets.RespondOwnedAssetsBuilder(asset=" + String.valueOf(this.asset) + ", issuanceAsset=" + String.valueOf(this.issuanceAsset) + ", tick=" + this.tick + ", universeIndex=" + this.universeIndex + ", siblings$value=" + Arrays.deepToString((Object[])this.siblings$value) + ")";
        }
    }
}

