/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import at.qubic.api.domain.std.response.AssetIssuance;
import at.qubic.api.domain.std.response.AssetOwnership;
import at.qubic.api.domain.std.response.AssetPossession;
import at.qubic.api.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;

public class RespondPossessedAssets {
    private final AssetPossession asset;
    private final AssetOwnership ownershipAsset;
    private final AssetIssuance issuanceAsset;
    private final int tick;
    private final int universeIndex;
    private final byte[][] siblings;

    public static RespondPossessedAssets fromBytes(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        AssetPossession assetPossession = AssetPossession.fromByteBuffer(buf);
        AssetOwnership assetOwnership = AssetOwnership.fromByteBuffer(buf);
        AssetIssuance assetIssuance = AssetIssuance.fromByteBuffer(buf);
        int tick = buf.getInt();
        int universeIndex = buf.getInt();
        RespondPossessedAssets rpa = RespondPossessedAssets.builder().asset(assetPossession).ownershipAsset(assetOwnership).issuanceAsset(assetIssuance).tick(tick).universeIndex(universeIndex).siblings(BufferUtil.getByteArrays(buf, 24, 32)).build();
        assert (buf.remaining() == 0);
        return rpa;
    }

    @Generated
    private static byte[][] $default$siblings() {
        return new byte[24][32];
    }

    @Generated
    RespondPossessedAssets(AssetPossession asset, AssetOwnership ownershipAsset, AssetIssuance issuanceAsset, int tick, int universeIndex, byte[][] siblings) {
        this.asset = asset;
        this.ownershipAsset = ownershipAsset;
        this.issuanceAsset = issuanceAsset;
        this.tick = tick;
        this.universeIndex = universeIndex;
        this.siblings = siblings;
    }

    @Generated
    public static RespondPossessedAssetsBuilder builder() {
        return new RespondPossessedAssetsBuilder();
    }

    @Generated
    public AssetPossession getAsset() {
        return this.asset;
    }

    @Generated
    public AssetOwnership getOwnershipAsset() {
        return this.ownershipAsset;
    }

    @Generated
    public AssetIssuance getIssuanceAsset() {
        return this.issuanceAsset;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    @Generated
    public int getUniverseIndex() {
        return this.universeIndex;
    }

    @Generated
    public byte[][] getSiblings() {
        return this.siblings;
    }

    @Generated
    public String toString() {
        return "RespondPossessedAssets(asset=" + String.valueOf(this.getAsset()) + ", ownershipAsset=" + String.valueOf(this.getOwnershipAsset()) + ", issuanceAsset=" + String.valueOf(this.getIssuanceAsset()) + ", tick=" + this.getTick() + ", universeIndex=" + this.getUniverseIndex() + ")";
    }

    @Generated
    public static class RespondPossessedAssetsBuilder {
        @Generated
        private AssetPossession asset;
        @Generated
        private AssetOwnership ownershipAsset;
        @Generated
        private AssetIssuance issuanceAsset;
        @Generated
        private int tick;
        @Generated
        private int universeIndex;
        @Generated
        private boolean siblings$set;
        @Generated
        private byte[][] siblings$value;

        @Generated
        RespondPossessedAssetsBuilder() {
        }

        @Generated
        public RespondPossessedAssetsBuilder asset(AssetPossession asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public RespondPossessedAssetsBuilder ownershipAsset(AssetOwnership ownershipAsset) {
            this.ownershipAsset = ownershipAsset;
            return this;
        }

        @Generated
        public RespondPossessedAssetsBuilder issuanceAsset(AssetIssuance issuanceAsset) {
            this.issuanceAsset = issuanceAsset;
            return this;
        }

        @Generated
        public RespondPossessedAssetsBuilder tick(int tick) {
            this.tick = tick;
            return this;
        }

        @Generated
        public RespondPossessedAssetsBuilder universeIndex(int universeIndex) {
            this.universeIndex = universeIndex;
            return this;
        }

        @Generated
        public RespondPossessedAssetsBuilder siblings(byte[][] siblings) {
            this.siblings$value = siblings;
            this.siblings$set = true;
            return this;
        }

        @Generated
        public RespondPossessedAssets build() {
            byte[][] siblings$value = this.siblings$value;
            if (!this.siblings$set) {
                siblings$value = RespondPossessedAssets.$default$siblings();
            }
            return new RespondPossessedAssets(this.asset, this.ownershipAsset, this.issuanceAsset, this.tick, this.universeIndex, siblings$value);
        }

        @Generated
        public String toString() {
            return "RespondPossessedAssets.RespondPossessedAssetsBuilder(asset=" + String.valueOf(this.asset) + ", ownershipAsset=" + String.valueOf(this.ownershipAsset) + ", issuanceAsset=" + String.valueOf(this.issuanceAsset) + ", tick=" + this.tick + ", universeIndex=" + this.universeIndex + ", siblings$value=" + Arrays.deepToString((Object[])this.siblings$value) + ")";
        }
    }
}

