/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class TickData {
    private final short computorIndex;
    private final short epoch;
    private final int tick;
    private final short millisecond;
    private final byte second;
    private final byte minute;
    private final byte hour;
    private final byte day;
    private final byte month;
    private final byte year;
    private final byte[] timelock;
    private final byte[][] transactionDigests;
    private final long[] contractFees;
    private final byte[] signature;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("20uu-MM-dd'T'HH:mm:ss.nX");

    public static TickData fromBytes(byte[] input) {
        ByteBuffer buf = ByteBuffer.wrap(input).order(ByteOrder.LITTLE_ENDIAN);
        TickData tickData = TickData.builder().computorIndex(buf.getShort()).epoch(buf.getShort()).tick(buf.getInt()).millisecond(buf.getShort()).second(buf.get()).minute(buf.get()).hour(buf.get()).day(buf.get()).month(buf.get()).year(buf.get()).timelock(TickData.getTimelock(buf)).transactionDigests(TickData.getTransactionDigests(buf)).contractFees(TickData.getContractFees(buf)).signature(TickData.getSignature(buf)).build();
        assert (buf.remaining() == 0);
        return tickData;
    }

    private static byte[] getSignature(ByteBuffer buf) {
        byte[] signature = new byte[64];
        buf.get(signature);
        return signature;
    }

    private static byte[] getTimelock(ByteBuffer buf) {
        byte[] timelock = new byte[32];
        buf.get(timelock);
        return timelock;
    }

    private static byte[][] getTransactionDigests(ByteBuffer buf) {
        byte[][] digests;
        for (byte[] digest : digests = new byte[1024][32]) {
            buf.get(digest);
        }
        return digests;
    }

    private static long[] getContractFees(ByteBuffer buf) {
        long[] contractFees = new long[1024];
        for (int i = 0; i < contractFees.length; ++i) {
            contractFees[i] = buf.getLong();
        }
        return contractFees;
    }

    public Instant getTimestamp() {
        return OffsetDateTime.of(2000 + this.year, this.month, this.day, this.hour, this.minute, this.second, Short.toUnsignedInt(this.millisecond) * 1000 * 1000, ZoneOffset.UTC).toInstant();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("computorIndex", this.computorIndex).append("epoch", this.epoch).append("tick", this.tick).append("timestamp", (Object)this.getTimestamp()).append("transactionDigests", this.toHexStrings(this.transactionDigests)).append("signature", (Object)Hex.encodeHexString((byte[])this.signature)).build();
    }

    private List<String> toHexStrings(byte[][] digests) {
        return Arrays.stream(digests).filter(this::notEmpty).map(Hex::encodeHexString).collect(Collectors.toList());
    }

    private boolean notEmpty(byte[] bytes) {
        for (byte b : bytes) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    @Generated
    private static byte $default$day() {
        return 1;
    }

    @Generated
    private static byte $default$month() {
        return 1;
    }

    @Generated
    private static byte[] $default$timelock() {
        return new byte[32];
    }

    @Generated
    private static byte[][] $default$transactionDigests() {
        return new byte[1024][32];
    }

    @Generated
    private static long[] $default$contractFees() {
        return new long[1024];
    }

    @Generated
    private static byte[] $default$signature() {
        return new byte[64];
    }

    @Generated
    TickData(short computorIndex, short epoch, int tick, short millisecond, byte second, byte minute, byte hour, byte day, byte month, byte year, byte[] timelock, byte[][] transactionDigests, long[] contractFees, byte[] signature) {
        this.computorIndex = computorIndex;
        this.epoch = epoch;
        this.tick = tick;
        this.millisecond = millisecond;
        this.second = second;
        this.minute = minute;
        this.hour = hour;
        this.day = day;
        this.month = month;
        this.year = year;
        this.timelock = timelock;
        this.transactionDigests = transactionDigests;
        this.contractFees = contractFees;
        this.signature = signature;
    }

    @Generated
    public static TickDataBuilder builder() {
        return new TickDataBuilder();
    }

    @Generated
    public short getComputorIndex() {
        return this.computorIndex;
    }

    @Generated
    public short getEpoch() {
        return this.epoch;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    @Generated
    public short getMillisecond() {
        return this.millisecond;
    }

    @Generated
    public byte getSecond() {
        return this.second;
    }

    @Generated
    public byte getMinute() {
        return this.minute;
    }

    @Generated
    public byte getHour() {
        return this.hour;
    }

    @Generated
    public byte getDay() {
        return this.day;
    }

    @Generated
    public byte getMonth() {
        return this.month;
    }

    @Generated
    public byte getYear() {
        return this.year;
    }

    @Generated
    public byte[] getTimelock() {
        return this.timelock;
    }

    @Generated
    public byte[][] getTransactionDigests() {
        return this.transactionDigests;
    }

    @Generated
    public long[] getContractFees() {
        return this.contractFees;
    }

    @Generated
    public byte[] getSignature() {
        return this.signature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TickData)) {
            return false;
        }
        TickData other = (TickData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getComputorIndex() != other.getComputorIndex()) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getTick() != other.getTick()) {
            return false;
        }
        if (this.getMillisecond() != other.getMillisecond()) {
            return false;
        }
        if (this.getSecond() != other.getSecond()) {
            return false;
        }
        if (this.getMinute() != other.getMinute()) {
            return false;
        }
        if (this.getHour() != other.getHour()) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getYear() != other.getYear()) {
            return false;
        }
        if (!Arrays.equals(this.getTimelock(), other.getTimelock())) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getTransactionDigests(), (Object[])other.getTransactionDigests())) {
            return false;
        }
        if (!Arrays.equals(this.getContractFees(), other.getContractFees())) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TickData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getComputorIndex();
        result = result * 59 + this.getEpoch();
        result = result * 59 + this.getTick();
        result = result * 59 + this.getMillisecond();
        result = result * 59 + this.getSecond();
        result = result * 59 + this.getMinute();
        result = result * 59 + this.getHour();
        result = result * 59 + this.getDay();
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getYear();
        result = result * 59 + Arrays.hashCode(this.getTimelock());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getTransactionDigests());
        result = result * 59 + Arrays.hashCode(this.getContractFees());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        return result;
    }

    @Generated
    public static class TickDataBuilder {
        @Generated
        private short computorIndex;
        @Generated
        private short epoch;
        @Generated
        private int tick;
        @Generated
        private short millisecond;
        @Generated
        private byte second;
        @Generated
        private byte minute;
        @Generated
        private byte hour;
        @Generated
        private boolean day$set;
        @Generated
        private byte day$value;
        @Generated
        private boolean month$set;
        @Generated
        private byte month$value;
        @Generated
        private byte year;
        @Generated
        private boolean timelock$set;
        @Generated
        private byte[] timelock$value;
        @Generated
        private boolean transactionDigests$set;
        @Generated
        private byte[][] transactionDigests$value;
        @Generated
        private boolean contractFees$set;
        @Generated
        private long[] contractFees$value;
        @Generated
        private boolean signature$set;
        @Generated
        private byte[] signature$value;

        @Generated
        TickDataBuilder() {
        }

        @Generated
        public TickDataBuilder computorIndex(short computorIndex) {
            this.computorIndex = computorIndex;
            return this;
        }

        @Generated
        public TickDataBuilder epoch(short epoch) {
            this.epoch = epoch;
            return this;
        }

        @Generated
        public TickDataBuilder tick(int tick) {
            this.tick = tick;
            return this;
        }

        @Generated
        public TickDataBuilder millisecond(short millisecond) {
            this.millisecond = millisecond;
            return this;
        }

        @Generated
        public TickDataBuilder second(byte second) {
            this.second = second;
            return this;
        }

        @Generated
        public TickDataBuilder minute(byte minute) {
            this.minute = minute;
            return this;
        }

        @Generated
        public TickDataBuilder hour(byte hour) {
            this.hour = hour;
            return this;
        }

        @Generated
        public TickDataBuilder day(byte day) {
            this.day$value = day;
            this.day$set = true;
            return this;
        }

        @Generated
        public TickDataBuilder month(byte month) {
            this.month$value = month;
            this.month$set = true;
            return this;
        }

        @Generated
        public TickDataBuilder year(byte year) {
            this.year = year;
            return this;
        }

        @Generated
        public TickDataBuilder timelock(byte[] timelock) {
            this.timelock$value = timelock;
            this.timelock$set = true;
            return this;
        }

        @Generated
        public TickDataBuilder transactionDigests(byte[][] transactionDigests) {
            this.transactionDigests$value = transactionDigests;
            this.transactionDigests$set = true;
            return this;
        }

        @Generated
        public TickDataBuilder contractFees(long[] contractFees) {
            this.contractFees$value = contractFees;
            this.contractFees$set = true;
            return this;
        }

        @Generated
        public TickDataBuilder signature(byte[] signature) {
            this.signature$value = signature;
            this.signature$set = true;
            return this;
        }

        @Generated
        public TickData build() {
            byte day$value = this.day$value;
            if (!this.day$set) {
                day$value = TickData.$default$day();
            }
            byte month$value = this.month$value;
            if (!this.month$set) {
                month$value = TickData.$default$month();
            }
            byte[] timelock$value = this.timelock$value;
            if (!this.timelock$set) {
                timelock$value = TickData.$default$timelock();
            }
            byte[][] transactionDigests$value = this.transactionDigests$value;
            if (!this.transactionDigests$set) {
                transactionDigests$value = TickData.$default$transactionDigests();
            }
            long[] contractFees$value = this.contractFees$value;
            if (!this.contractFees$set) {
                contractFees$value = TickData.$default$contractFees();
            }
            byte[] signature$value = this.signature$value;
            if (!this.signature$set) {
                signature$value = TickData.$default$signature();
            }
            return new TickData(this.computorIndex, this.epoch, this.tick, this.millisecond, this.second, this.minute, this.hour, day$value, month$value, this.year, timelock$value, transactionDigests$value, contractFees$value, signature$value);
        }

        @Generated
        public String toString() {
            return "TickData.TickDataBuilder(computorIndex=" + this.computorIndex + ", epoch=" + this.epoch + ", tick=" + this.tick + ", millisecond=" + this.millisecond + ", second=" + this.second + ", minute=" + this.minute + ", hour=" + this.hour + ", day$value=" + this.day$value + ", month$value=" + this.month$value + ", year=" + this.year + ", timelock$value=" + Arrays.toString(this.timelock$value) + ", transactionDigests$value=" + Arrays.deepToString((Object[])this.transactionDigests$value) + ", contractFees$value=" + Arrays.toString(this.contractFees$value) + ", signature$value=" + Arrays.toString(this.signature$value) + ")";
        }
    }
}

