/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lombok.Generated;

public class TickInfo {
    private final short tickDuration;
    private final short epoch;
    private final int tick;
    private final short numberOfAlignedVotes;
    private final short numberOfMisalignedVotes;
    private final int initialTick;

    public static TickInfo fromBytes(byte[] input) {
        ByteBuffer buf = ByteBuffer.wrap(input);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        TickInfo tickInfo = TickInfo.builder().tickDuration(buf.getShort()).epoch(buf.getShort()).tick(buf.getInt()).numberOfAlignedVotes(buf.getShort()).numberOfMisalignedVotes(buf.getShort()).initialTick(buf.getInt()).build();
        assert (buf.remaining() == 0);
        return tickInfo;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(this.tickDuration);
        buf.putShort(this.epoch);
        buf.putInt(this.tick);
        buf.putShort(this.numberOfAlignedVotes);
        buf.putShort(this.numberOfMisalignedVotes);
        buf.putInt(this.initialTick);
        return buf;
    }

    @Generated
    TickInfo(short tickDuration, short epoch, int tick, short numberOfAlignedVotes, short numberOfMisalignedVotes, int initialTick) {
        this.tickDuration = tickDuration;
        this.epoch = epoch;
        this.tick = tick;
        this.numberOfAlignedVotes = numberOfAlignedVotes;
        this.numberOfMisalignedVotes = numberOfMisalignedVotes;
        this.initialTick = initialTick;
    }

    @Generated
    public static TickInfoBuilder builder() {
        return new TickInfoBuilder();
    }

    @Generated
    public short getTickDuration() {
        return this.tickDuration;
    }

    @Generated
    public short getEpoch() {
        return this.epoch;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    @Generated
    public short getNumberOfAlignedVotes() {
        return this.numberOfAlignedVotes;
    }

    @Generated
    public short getNumberOfMisalignedVotes() {
        return this.numberOfMisalignedVotes;
    }

    @Generated
    public int getInitialTick() {
        return this.initialTick;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TickInfo)) {
            return false;
        }
        TickInfo other = (TickInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTickDuration() != other.getTickDuration()) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getTick() != other.getTick()) {
            return false;
        }
        if (this.getNumberOfAlignedVotes() != other.getNumberOfAlignedVotes()) {
            return false;
        }
        if (this.getNumberOfMisalignedVotes() != other.getNumberOfMisalignedVotes()) {
            return false;
        }
        return this.getInitialTick() == other.getInitialTick();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TickInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTickDuration();
        result = result * 59 + this.getEpoch();
        result = result * 59 + this.getTick();
        result = result * 59 + this.getNumberOfAlignedVotes();
        result = result * 59 + this.getNumberOfMisalignedVotes();
        result = result * 59 + this.getInitialTick();
        return result;
    }

    @Generated
    public String toString() {
        return "TickInfo(tickDuration=" + this.getTickDuration() + ", epoch=" + this.getEpoch() + ", tick=" + this.getTick() + ", numberOfAlignedVotes=" + this.getNumberOfAlignedVotes() + ", numberOfMisalignedVotes=" + this.getNumberOfMisalignedVotes() + ", initialTick=" + this.getInitialTick() + ")";
    }

    @Generated
    public static class TickInfoBuilder {
        @Generated
        private short tickDuration;
        @Generated
        private short epoch;
        @Generated
        private int tick;
        @Generated
        private short numberOfAlignedVotes;
        @Generated
        private short numberOfMisalignedVotes;
        @Generated
        private int initialTick;

        @Generated
        TickInfoBuilder() {
        }

        @Generated
        public TickInfoBuilder tickDuration(short tickDuration) {
            this.tickDuration = tickDuration;
            return this;
        }

        @Generated
        public TickInfoBuilder epoch(short epoch) {
            this.epoch = epoch;
            return this;
        }

        @Generated
        public TickInfoBuilder tick(int tick) {
            this.tick = tick;
            return this;
        }

        @Generated
        public TickInfoBuilder numberOfAlignedVotes(short numberOfAlignedVotes) {
            this.numberOfAlignedVotes = numberOfAlignedVotes;
            return this;
        }

        @Generated
        public TickInfoBuilder numberOfMisalignedVotes(short numberOfMisalignedVotes) {
            this.numberOfMisalignedVotes = numberOfMisalignedVotes;
            return this;
        }

        @Generated
        public TickInfoBuilder initialTick(int initialTick) {
            this.initialTick = initialTick;
            return this;
        }

        @Generated
        public TickInfo build() {
            return new TickInfo(this.tickDuration, this.epoch, this.tick, this.numberOfAlignedVotes, this.numberOfMisalignedVotes, this.initialTick);
        }

        @Generated
        public String toString() {
            return "TickInfo.TickInfoBuilder(tickDuration=" + this.tickDuration + ", epoch=" + this.epoch + ", tick=" + this.tick + ", numberOfAlignedVotes=" + this.numberOfAlignedVotes + ", numberOfMisalignedVotes=" + this.numberOfMisalignedVotes + ", initialTick=" + this.initialTick + ")";
        }
    }
}

