/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.network;

import at.qubic.api.domain.std.response.TickInfo;
import at.qubic.api.network.NetworkStatus;
import at.qubic.api.network.Node;
import at.qubic.api.network.TickComparator;
import at.qubic.api.network.TickStatus;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HealthCheckNetworkStatus
implements NetworkStatus {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCheckNetworkStatus.class);
    private static final TickComparator TICK_COMPARATOR = new TickComparator();
    private Instant previousUpdate = Instant.EPOCH;
    private Instant latestUpdate = Instant.EPOCH;
    private TickInfo latestTick = TickInfo.builder().epoch((short)1).tick(1).build();

    @Override
    public Mono<TickInfo> update(Collection<Node> nodes) {
        Iterable tickInfos = nodes.stream().map(n -> Mono.defer(n::getCurrentTickInfo).defaultIfEmpty((Object)TickInfo.builder().build()).onErrorReturn((Object)TickInfo.builder().build())).collect(Collectors.toList());
        return Mono.zipDelayError((Iterable)tickInfos, HealthCheckNetworkStatus.getLatestTickFunction()).doFirst(this::setLatestUpdateTime).map(ti -> (TickInfo)ti).doOnNext(this::setLatestTick).doOnSuccess(ti -> this.logStats(nodes)).doOnError(t -> log.error("Health check failed.", t));
    }

    @Override
    public Mono<TickStatus> getTickStatus() {
        return Mono.just((Object)TickStatus.builder().latestUpdate(this.latestUpdate).tickInfo(this.latestTick).build());
    }

    private void setLatestTick(TickInfo currentTick) {
        log.info("Current tick: {}", (Object)currentTick);
        if (this.epoch(currentTick) >= this.epoch(this.latestTick) && this.tick(currentTick) >= this.tick(this.latestTick)) {
            this.latestUpdate = Instant.now();
            this.latestTick = currentTick;
            if (this.tick(currentTick) > this.tick(this.latestTick)) {
                log.info("Updated network status to tick [{}] at [{}].", (Object)this.tick(this.latestTick), (Object)this.latestUpdate);
            }
        } else {
            this.resetLatestUpdateTime();
            log.warn("Not updating epoch [{}] and tick [{}] because current tick info is older: {}", new Object[]{this.epoch(this.latestTick), this.tick(this.latestTick), currentTick});
        }
    }

    protected void logStats(Collection<Node> nodes) {
        TreeMap nodesAtTick = new TreeMap(Comparator.reverseOrder());
        for (Node node : nodes) {
            int tick = Objects.requireNonNull(node.getTickInfo()).getTick();
            nodesAtTick.computeIfAbsent(tick, x -> new TreeSet());
            ((SortedSet)nodesAtTick.get(tick)).add(Objects.requireNonNull(node.getName()));
        }
        int currentTick = this.latestTick.getTick();
        for (Integer i : nodesAtTick.keySet()) {
            SortedSet n = (SortedSet)nodesAtTick.get(i);
            String message = String.format("[%d] of [%d] node(s) at tick [%d]: %s", n.size(), nodes.size(), i, n);
            if (currentTick <= i + 1) {
                log.info(message);
                continue;
            }
            log.debug(message);
        }
    }

    private static Function<Object[], Object> getLatestTickFunction() {
        return tis -> Arrays.stream(tis).max((o1, o2) -> TICK_COMPARATOR.compare((TickInfo)o1, (TickInfo)o2)).orElseGet(() -> TickInfo.builder().build());
    }

    private int tick(TickInfo tickInfo) {
        return tickInfo.getTick();
    }

    private short epoch(TickInfo tickInfo) {
        return tickInfo.getEpoch();
    }

    private void setLatestUpdateTime() {
        this.previousUpdate = this.latestUpdate;
        this.latestUpdate = Instant.now();
    }

    private void resetLatestUpdateTime() {
        this.latestUpdate = this.previousUpdate;
    }
}

