/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.network;

import at.qubic.api.QubicRequest;
import at.qubic.api.domain.MessageType;
import at.qubic.api.domain.QubicMessage;
import at.qubic.api.domain.qx.request.QxGetAssetOrders;
import at.qubic.api.domain.qx.request.QxGetEntityOrders;
import at.qubic.api.domain.qx.request.QxGetFees;
import at.qubic.api.domain.qx.response.AssetOrder;
import at.qubic.api.domain.qx.response.EntityOrder;
import at.qubic.api.domain.qx.response.QxFees;
import at.qubic.api.domain.std.SignedTransaction;
import at.qubic.api.domain.std.request.BroadcastTransaction;
import at.qubic.api.domain.std.request.RequestCurrentTickInfo;
import at.qubic.api.domain.std.request.RequestEntity;
import at.qubic.api.domain.std.request.RequestOwnedAssets;
import at.qubic.api.domain.std.request.RequestPossessedAssets;
import at.qubic.api.domain.std.request.RequestTickData;
import at.qubic.api.domain.std.request.RequestTickTransactions;
import at.qubic.api.domain.std.response.Entity;
import at.qubic.api.domain.std.response.ExchangePublicPeers;
import at.qubic.api.domain.std.response.RespondOwnedAssets;
import at.qubic.api.domain.std.response.RespondPossessedAssets;
import at.qubic.api.domain.std.response.TickData;
import at.qubic.api.domain.std.response.TickInfo;
import at.qubic.api.exception.InvalidResponseException;
import at.qubic.api.network.BasicNodeOperations;
import at.qubic.api.network.PeerListener;
import at.qubic.api.tcp.TcpClientFactory;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientConfig;

public class Node {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    public static final int REQUEST_TIMEOUT = 5;
    private Instant latestTickUpdate = Instant.EPOCH;
    private TickInfo tickInfo = TickInfo.builder().build();
    private final TcpClient client;
    private final String name;
    private final List<PeerListener> peerListeners = Collections.synchronizedList(new ArrayList(2));
    private final BasicNodeOperations basicNodeOperations = new BasicNodeOperations();

    public Node(TcpClient tcpClient) {
        this.client = tcpClient;
        this.name = Node.getHostName(tcpClient);
    }

    public Node(String host, int port) {
        this.name = host;
        this.client = TcpClientFactory.tcpClient(host, port);
    }

    public Mono<TickInfo> getCurrentTickInfo() {
        Mono request = Mono.just((Object)RequestCurrentTickInfo.builder().build());
        return this.sendAndReceiveNext((Mono<? extends QubicRequest>)request, MessageType.RESPOND_CURRENT_TICK_INFO).map(response -> TickInfo.fromBytes(response.getPayload())).switchIfEmpty(Mono.defer(() -> Node.invalidResponseMessage(this.name, "get current tick info"))).doOnNext(ti -> log.info("[{}] Received tick info: {}", (Object)this.name, (Object)ti.getTick())).doOnNext(this::updateTickInfo);
    }

    public Mono<TickData> getTickData(int tick) {
        Mono request = Mono.just((Object)RequestTickData.builder().tick(tick).build());
        return this.sendAndReceiveNext((Mono<? extends QubicRequest>)request, MessageType.BROADCAST_FUTURE_TICK_DATA).map(message -> TickData.fromBytes(message.getPayload())).doOnNext(td -> log.debug("[{}] Got tick data for tick [{}]: [{}].", new Object[]{this.name, tick, td != null}));
    }

    public Mono<Entity> getEntity(Mono<byte[]> publicKey) {
        Mono requestMessage = publicKey.map(pk -> RequestEntity.builder().publicKey((byte[])pk).build());
        return this.sendAndReceiveNext((Mono<QubicRequest>)requestMessage).map(response -> Entity.fromBytes(response.getPayload())).switchIfEmpty(Mono.defer(() -> Node.invalidResponseMessage(this.name, "get entity"))).doOnNext(e -> log.debug("[{}]: {}", (Object)this.name, e));
    }

    public Mono<SignedTransaction> broadcastTransaction(Mono<SignedTransaction> transaction) {
        return transaction.doOnNext(stx -> log.info("[{}] Sending transaction [{}].", (Object)this.name, (Object)stx.getTransactionHash())).map(tx -> BroadcastTransaction.builder().transaction((SignedTransaction)tx).build()).flatMap(req -> this.send((Mono<QubicRequest>)Mono.just((Object)req)).map(conn -> req.getTransaction()));
    }

    public Flux<SignedTransaction> getTickTransactions(int tick) {
        Mono request = Mono.just((Object)RequestTickTransactions.builder().tick(tick).build());
        return this.sendAndReceive((Mono<QubicRequest>)request).map(message -> SignedTransaction.fromBytes(message.getPayload()));
    }

    public Flux<RespondOwnedAssets> getOwnedAssets(Mono<byte[]> publicKey) {
        Mono requestMono = publicKey.map(pk -> RequestOwnedAssets.builder().publicKey((byte[])pk).build());
        return this.sendAndReceive((Mono<QubicRequest>)requestMono, MessageType.RESPOND_OWNED_ASSETS).map(response -> RespondOwnedAssets.fromBytes(response.getPayload())).doOnNext(r -> log.debug("[{}]: {}", (Object)this.name, r));
    }

    public Flux<RespondPossessedAssets> getPossessedAssets(Mono<byte[]> publicKey) {
        Mono requestMono = publicKey.map(pk -> RequestPossessedAssets.builder().publicKey((byte[])pk).build());
        return this.sendAndReceive((Mono<QubicRequest>)requestMono, MessageType.RESPOND_POSSESSED_ASSETS).map(response -> RespondPossessedAssets.fromBytes(response.getPayload())).doOnNext(r -> log.debug("[{}]: {}", (Object)this.name, r));
    }

    public Mono<QxFees> getQxFees() {
        return this.sendAndReceiveNext((Mono<? extends QubicRequest>)Mono.just((Object)new QxGetFees()), MessageType.RESPOND_CONTRACT_FUNCTION).filter(qm -> ArrayUtils.getLength((Object)qm.getPayload()) >= 12).map(response -> QxFees.fromBytes(response.getPayload())).switchIfEmpty(Mono.defer(() -> Node.invalidResponseMessage(this.name, "get qx fees"))).doOnNext(r -> log.debug("[{}]: {}", (Object)this.name, r));
    }

    public Mono<List<AssetOrder>> getQxAssetOrders(Mono<QxGetAssetOrders> request) {
        return this.sendAndReceiveNext(request, MessageType.RESPOND_CONTRACT_FUNCTION).filter(qm -> ArrayUtils.getLength((Object)qm.getPayload()) >= 12288).map(response -> AssetOrder.getAssetOrders(response.getPayload())).switchIfEmpty(Mono.defer(() -> Node.invalidResponseMessage(this.name, "get qx asset orders"))).doOnNext(r -> log.debug("[{}]: {}", (Object)this.name, r));
    }

    public Mono<List<EntityOrder>> getQxEntityOrders(Mono<QxGetEntityOrders> request) {
        return this.sendAndReceiveNext(request, MessageType.RESPOND_CONTRACT_FUNCTION).filter(qm -> ArrayUtils.getLength((Object)qm.getPayload()) >= 14336).map(response -> EntityOrder.getEntityOrders(response.getPayload())).switchIfEmpty(Mono.defer(() -> Node.invalidResponseMessage(this.name, "get qx entity orders"))).doOnNext(r -> log.debug("[{}]: {}", (Object)this.name, r));
    }

    private static <T> Mono<T> invalidResponseMessage(String name, String operation) {
        String m = String.format("[%s] Received invalid response (%s).", name, operation);
        log.error(m);
        return Mono.error((Throwable)new InvalidResponseException(m));
    }

    private Mono<QubicMessage> sendAndReceiveNext(Mono<QubicRequest> request) {
        return this.basicNodeOperations.sendAndReceiveNext(this, request);
    }

    private Mono<QubicMessage> sendAndReceiveNext(Mono<? extends QubicRequest> request, MessageType messageType) {
        return this.basicNodeOperations.sendAndReceiveNext(this, request, messageType);
    }

    private Flux<QubicMessage> sendAndReceive(Mono<QubicRequest> request) {
        return this.basicNodeOperations.sendAndReceive(this, request);
    }

    private Flux<QubicMessage> sendAndReceive(Mono<QubicRequest> request, MessageType type) {
        return this.basicNodeOperations.sendAndReceive(this, request, type);
    }

    private Mono<? extends Connection> send(Mono<QubicRequest> requestMessage) {
        return this.basicNodeOperations.send(this, requestMessage);
    }

    private void updateTickInfo(TickInfo tickInfo) {
        this.latestTickUpdate = Instant.now();
        this.tickInfo = tickInfo;
        log.debug("[{}] Updating tick info to {}.", (Object)this.name, (Object)tickInfo);
    }

    void updatePublicPeers(QubicMessage qubicMessage) {
        if (MessageType.EXCHANGE_PUBLIC_PEERS == qubicMessage.getHeader().getType()) {
            String[] peers = ExchangePublicPeers.fromBytes(qubicMessage.getPayload()).getPeers();
            this.peerListeners.forEach(pl -> pl.publishPeers(peers));
        }
    }

    public void addPeerListener(PeerListener peerListener) {
        this.peerListeners.add(peerListener);
    }

    private static String getHostName(TcpClient tcpClient) {
        Objects.requireNonNull(tcpClient);
        Objects.requireNonNull((TcpClientConfig)tcpClient.configuration());
        return ((InetSocketAddress)((TcpClientConfig)tcpClient.configuration()).remoteAddress().get()).getHostName();
    }

    @Generated
    public String toString() {
        return "Node(name=" + this.getName() + ")";
    }

    @Generated
    public Instant getLatestTickUpdate() {
        return this.latestTickUpdate;
    }

    @Generated
    public TickInfo getTickInfo() {
        return this.tickInfo;
    }

    @Generated
    TcpClient getClient() {
        return this.client;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    List<PeerListener> getPeerListeners() {
        return this.peerListeners;
    }
}

