/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.network;

import at.qubic.api.exception.NoNodeAvailableException;
import at.qubic.api.network.FixNodesStrategy;
import at.qubic.api.network.Node;
import at.qubic.api.network.NodesManagementStrategy;
import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Nodes
implements NodesManagementStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Nodes.class);
    private final NodesManagementStrategy nodesStrategy;

    public Nodes() {
        this.nodesStrategy = new FixNodesStrategy();
    }

    public Nodes(NodesManagementStrategy nodesStrategy) {
        this.nodesStrategy = nodesStrategy;
    }

    public Mono<Node> getNode() {
        return this.getNodes(1).singleOrEmpty().doOnNext(node -> log.debug("Getting node [{}].", (Object)node.getName())).switchIfEmpty(Nodes.noNodeAvailableError());
    }

    private static Mono<Node> noNodeAvailableError() {
        return Mono.error((Throwable)new NoNodeAvailableException("Could not get node. No node available."));
    }

    @Override
    public Node addNode(String host) {
        return this.nodesStrategy.addNode(host);
    }

    @Override
    public Flux<Node> getNodes(int max) {
        return this.nodesStrategy.getNodes(max);
    }

    @Override
    public Mono<Instant> forceNetworkUpdate(Instant updateIfBefore) {
        return this.nodesStrategy.forceNetworkUpdate(updateIfBefore);
    }
}

