/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.network;

import at.qubic.api.domain.std.response.TickInfo;
import at.qubic.api.network.NetworkStatus;
import at.qubic.api.network.Node;
import at.qubic.api.network.NodesManagementStrategy;
import at.qubic.api.network.TickStatus;
import at.qubic.api.properties.NetworkProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public abstract class NodesManagementAdapter
implements NodesManagementStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NodesManagementAdapter.class);
    private static final int MAX_TICK_DELAY = 1;
    private static final int DEFAULT_PORT = 21841;
    private static final Duration REFRESH_INTERVAL = Duration.ofSeconds(60L);
    protected final int port;
    protected final int maxTickDelay;
    protected final Duration refreshInterval;
    protected final Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();
    protected final NetworkStatus networkStatus;

    public NodesManagementAdapter(NetworkStatus networkStatus) {
        this(networkStatus, new NetworkProperties(21841, 1, REFRESH_INTERVAL));
    }

    public NodesManagementAdapter(NetworkStatus networkStatus, NetworkProperties networkProperties) {
        this.networkStatus = networkStatus;
        log.info("Network status implementation: {}", (Object)networkStatus.getClass().getSimpleName());
        this.port = networkProperties.getPort();
        this.maxTickDelay = networkProperties.getMaxTickDelay();
        this.refreshInterval = networkProperties.getRefreshInterval();
        log.info("Using port [{}], max tick delay [{}], refresh interval [{}]", new Object[]{this.port, this.maxTickDelay, this.refreshInterval});
    }

    @Override
    public Node addNode(String host) {
        return this.nodes.computeIfAbsent(host, h -> this.newNode((String)h, this.port));
    }

    protected void addNode(Node node) {
        this.nodes.put(node.getName(), node);
    }

    @Override
    public Flux<Node> getNodes(int max) {
        return Mono.defer(this.networkStatus::getTickStatus).filter(ts -> ts.isValid() && this.getCurrentNodes(ts.getTickInfo(), this.maxTickDelay).size() >= max).doOnNext(this::updateNetworkStatusAsync).map(TickStatus::getTickInfo).switchIfEmpty(Mono.defer(this::updateNetworkStatus)).flatMapMany(ti -> this.getShuffledCurrentNodes((TickInfo)ti, this.maxTickDelay)).take((long)max);
    }

    protected Node newNode(String host, int port) {
        log.info("Creating new node [{}].", (Object)host);
        return new Node(host, port);
    }

    protected Flux<Node> getShuffledCurrentNodes(TickInfo ti, int offset) {
        List<Node> currentNodes = this.getCurrentNodes(ti, offset);
        Collections.shuffle(currentNodes);
        return Flux.fromIterable(currentNodes);
    }

    protected List<Node> getCurrentNodes(TickInfo ti, int offset) {
        return this.nodes.values().stream().filter(n -> NodesManagementAdapter.isAtTick(n.getTickInfo(), ti.getEpoch(), ti.getTick() - offset)).collect(Collectors.toList());
    }

    @Override
    public Mono<Instant> forceNetworkUpdate(Instant updateIfBefore) {
        return Mono.defer(this.networkStatus::getTickStatus).map(TickStatus::getLatestUpdate).flatMap(updatedAt -> {
            if (updatedAt.isBefore(updateIfBefore)) {
                return this.networkStatus.update(this.nodes.values()).map(ti -> Instant.now());
            }
            return Mono.just((Object)updatedAt);
        });
    }

    protected Mono<TickInfo> updateNetworkStatus() {
        return this.networkStatus.update(this.nodes.values()).doFirst(() -> log.info("Network status update..."));
    }

    protected void updateNetworkStatusAsync(TickStatus ts) {
        if (!ts.isValid() || ts.lastUpdatedBefore(Instant.now().minus(this.refreshInterval))) {
            this.networkStatus.update(this.nodes.values()).doFirst(() -> log.info("Asynchronous network status update...")).subscribeOn(Schedulers.boundedElastic()).subscribe();
        }
    }

    private static boolean isAtTick(TickInfo tickInfo, short epoch, int tick) {
        return tickInfo.getEpoch() >= Math.max(1, epoch) && tickInfo.getTick() >= Math.max(1, tick);
    }
}

