/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.service;

import at.qubic.api.crypto.IdentityUtil;
import at.qubic.api.domain.qx.request.QxGetAssetAskOrders;
import at.qubic.api.domain.qx.request.QxGetAssetBidOrders;
import at.qubic.api.domain.qx.request.QxGetAssetOrders;
import at.qubic.api.domain.qx.request.QxGetEntityAskOrders;
import at.qubic.api.domain.qx.request.QxGetEntityBidOrders;
import at.qubic.api.domain.qx.request.QxGetEntityOrders;
import at.qubic.api.domain.qx.response.AssetOrder;
import at.qubic.api.domain.qx.response.EntityOrder;
import at.qubic.api.domain.qx.response.QxFees;
import at.qubic.api.domain.std.SignedTransaction;
import at.qubic.api.domain.std.Transaction;
import at.qubic.api.domain.std.response.Entity;
import at.qubic.api.domain.std.response.RespondOwnedAssets;
import at.qubic.api.domain.std.response.RespondPossessedAssets;
import at.qubic.api.domain.std.response.TickData;
import at.qubic.api.domain.std.response.TickInfo;
import at.qubic.api.network.Node;
import at.qubic.api.network.Nodes;
import at.qubic.api.service.TransactionService;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ComputorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputorService.class);
    private final Nodes nodes;
    private final IdentityUtil idu;
    private final TransactionService transactionService;

    public ComputorService(Nodes nodes) {
        this(nodes, new IdentityUtil());
    }

    public ComputorService(Nodes nodes, IdentityUtil identityUtil) {
        this(nodes, identityUtil, new TransactionService(identityUtil));
    }

    public ComputorService(Nodes nodes, IdentityUtil idu, TransactionService transactionService) {
        this.nodes = nodes;
        this.idu = idu;
        this.transactionService = transactionService;
    }

    public Mono<TickInfo> getCurrentTickInfo() {
        return this.nodes.getNode().flatMap(Node::getCurrentTickInfo);
    }

    public Mono<Entity> getEntity(String identity) {
        Mono publicKey = Mono.just((Object)identity).map(this.idu::getPublicKeyFromIdentity);
        return this.nodes.getNode().doOnNext(n -> log.info("[{}] Query id [{}].", (Object)n.getName(), (Object)identity)).flatMap(n -> n.getEntity((Mono<byte[]>)publicKey));
    }

    public Mono<SignedTransaction> sendTransaction(SignedTransaction signedTransaction) {
        return this.nodes.getNode().flatMap(node -> node.broadcastTransaction((Mono<SignedTransaction>)Mono.just((Object)signedTransaction)).doOnSuccess(tx -> log.info("[{}] Sent {}", (Object)node.getName(), (Object)this.getTransactionLogString((SignedTransaction)tx))));
    }

    public Mono<SignedTransaction> sendTransaction(String seed, String targetIdentity, long amount, int tickOffset) {
        return this.sendTransaction(this.createSignedTransferTransaction(seed, targetIdentity, amount, tickOffset));
    }

    public Mono<SignedTransaction> sendTransaction(Function<TickInfo, SignedTransaction> createTransactionFunction) {
        return this.nodes.getNode().flatMap(node -> node.getCurrentTickInfo().map(createTransactionFunction).flatMap(tx -> node.broadcastTransaction((Mono<SignedTransaction>)Mono.just((Object)tx))).doOnSuccess(tx -> log.info(this.getTransactionLogString((SignedTransaction)tx))));
    }

    private Function<TickInfo, SignedTransaction> createSignedTransferTransaction(String seed, String targetIdentity, long amount, int tickOffset) {
        return ti -> this.transactionService.createTransaction(ti.getTick() + tickOffset, seed, targetIdentity, amount);
    }

    public Mono<TickData> getTickData(int tick) {
        return this.nodes.getNode().flatMap(node -> node.getTickData(tick).doOnNext(td -> log.info("{}", td)));
    }

    public Flux<SignedTransaction> getTickTransactions(int tick) {
        return this.nodes.getNode().flatMapMany(node -> node.getTickTransactions(tick).map(tx -> {
            tx.setTransactionHash(this.transactionService.calculateTransactionHash((SignedTransaction)tx));
            log.debug(this.getTransactionLogString((SignedTransaction)tx));
            return tx;
        }));
    }

    public Flux<RespondOwnedAssets> getOwnedAssets(String identity) {
        Mono publicKey = Mono.just((Object)identity).map(this.idu::getPublicKeyFromIdentity);
        return this.nodes.getNode().doOnNext(n -> log.info("[{}] Get owned assets for [{}].", (Object)n.getName(), (Object)identity)).flatMapMany(n -> n.getOwnedAssets((Mono<byte[]>)publicKey));
    }

    public Flux<RespondPossessedAssets> getPossessedAssets(String identity) {
        Mono publicKey = Mono.just((Object)identity).map(this.idu::getPublicKeyFromIdentity);
        return this.nodes.getNode().doOnNext(n -> log.info("[{}] Get possessed assets for [{}].", (Object)n.getName(), (Object)identity)).flatMapMany(n -> n.getPossessedAssets((Mono<byte[]>)publicKey));
    }

    public Mono<QxFees> getQxFees() {
        return this.nodes.getNode().doOnNext(n -> log.info("[{}] Get qx fees.", (Object)n.getName())).flatMap(Node::getQxFees);
    }

    public Mono<List<AssetOrder>> getQxAskAssetOrders(String issuer, String assetName, long offset) {
        QxGetAssetAskOrders request = new QxGetAssetAskOrders(this.idu.getPublicKeyFromIdentity(issuer), assetName, offset);
        return this.getQxAssetOrders(request);
    }

    public Mono<List<AssetOrder>> getQxBidAssetOrders(String issuer, String assetName, long offset) {
        QxGetAssetBidOrders request = new QxGetAssetBidOrders(this.idu.getPublicKeyFromIdentity(issuer), assetName, offset);
        return this.getQxAssetOrders(request);
    }

    private Mono<List<AssetOrder>> getQxAssetOrders(QxGetAssetOrders request) {
        return this.nodes.getNode().doOnNext(n -> log.info("[{}] Get qx orders for asset [{}]. Offset: [{}].", new Object[]{n.getName(), request.getAssetName(), request.getOffset()})).flatMap(n -> n.getQxAssetOrders((Mono<QxGetAssetOrders>)Mono.just((Object)request)));
    }

    public Mono<List<EntityOrder>> getQxAskEntityOrders(String identity, long offset) {
        QxGetEntityAskOrders request = new QxGetEntityAskOrders(this.idu.getPublicKeyFromIdentity(identity), offset);
        return this.getQxEntityOrders(request, identity);
    }

    public Mono<List<EntityOrder>> getQxBidEntityOrders(String identity, long offset) {
        QxGetEntityBidOrders request = new QxGetEntityBidOrders(this.idu.getPublicKeyFromIdentity(identity), offset);
        return this.getQxEntityOrders(request, identity);
    }

    private Mono<List<EntityOrder>> getQxEntityOrders(QxGetEntityOrders request, String identity) {
        return this.nodes.getNode().doOnNext(n -> log.info("[{}] Get qx orders for entity [{}]. Offset: [{}].", new Object[]{n.getName(), identity, request.getOffset()})).flatMap(n -> n.getQxEntityOrders((Mono<QxGetEntityOrders>)Mono.just((Object)request)));
    }

    public Mono<Instant> forceNetworkUpdateIfBefore(Instant updateIfBefore) {
        return this.nodes.forceNetworkUpdate(updateIfBefore);
    }

    private String getTransactionLogString(SignedTransaction signedTransaction) {
        Transaction transaction = signedTransaction.getTransaction();
        return String.format("tx [%s], tick [%d], [%s] => [%s], qu [%d], hash [%s], input type [%s], input size [%s], extra data [%s]", StringUtils.abbreviate((String)signedTransaction.getTransactionHash(), (String)"", (int)10), transaction.getTick(), this.idu.getIdentityFromPublicKey(transaction.getSourcePublicKey()), this.idu.getIdentityFromPublicKey(transaction.getDestinationPublicKey()), transaction.getAmount(), signedTransaction.getTransactionHash(), transaction.getInputType(), transaction.getInputSize(), transaction.getExtraData() == null ? null : Hex.encodeHexString((byte[])transaction.getExtraData()));
    }
}

