/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.service;

import at.qubic.api.crypto.IdentityUtil;
import at.qubic.api.crypto.KangarooTwelve;
import at.qubic.api.crypto.QubicFourQ;
import at.qubic.api.crypto.SchnorrQubic;
import at.qubic.api.domain.std.SignedTransaction;
import at.qubic.api.domain.std.Transaction;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class TransactionService {
    private final IdentityUtil identityUtil;
    private final SchnorrQubic signing;

    public TransactionService() {
        this(new IdentityUtil());
    }

    public TransactionService(IdentityUtil identityUtil) {
        this(identityUtil, new QubicFourQ());
    }

    public TransactionService(IdentityUtil identityUtil, SchnorrQubic schnorrQubic) {
        this.identityUtil = identityUtil;
        this.signing = schnorrQubic;
    }

    public SignedTransaction createTransaction(int tick, String seed, String destinationIdentity, long amount) {
        return this.createTransaction(tick, seed, destinationIdentity, amount, (short)0, new byte[0]);
    }

    public SignedTransaction createTransaction(int tick, String seed, String destinationIdentity, long amount, short inputType, byte[] extraData) {
        byte[] subSeed = this.identityUtil.getSubSeedFromSeed(seed);
        byte[] sourcePublicKey = this.identityUtil.getPublicKeyFromPrivateKey(this.identityUtil.getPrivateKeyFromSubSeed(subSeed));
        byte[] destinationPublicKey = this.identityUtil.getPublicKeyFromIdentity(destinationIdentity);
        Transaction transaction = TransactionService.createTransaction(tick, amount, sourcePublicKey, destinationPublicKey, inputType, extraData);
        byte[] signature = this.createSignatureWithSubSeed(subSeed, sourcePublicKey, transaction);
        return this.createSignedTransaction(transaction, signature);
    }

    public SignedTransaction createTransactionWithNonceK(int tick, byte[] nonceK, String sourceIdentity, String destinationIdentity, long amount) {
        return this.createTransactionWithNonceK(tick, nonceK, sourceIdentity, destinationIdentity, amount, (short)0, new byte[0]);
    }

    public SignedTransaction createTransactionWithNonceK(int tick, byte[] nonceK, String sourceIdentity, String destinationIdentity, long amount, short inputType, byte[] extraData) {
        if (ArrayUtils.getLength((Object)nonceK) != 64) {
            throw new IllegalArgumentException("Nonce k must be 64 bytes");
        }
        byte[] sourcePublicKey = this.identityUtil.getPublicKeyFromIdentity(sourceIdentity);
        byte[] destinationPublicKey = this.identityUtil.getPublicKeyFromIdentity(destinationIdentity);
        Transaction transaction = TransactionService.createTransaction(tick, amount, sourcePublicKey, destinationPublicKey, inputType, extraData);
        byte[] signature = this.createSignatureWithNonceK(nonceK, sourcePublicKey, transaction);
        return this.createSignedTransaction(transaction, signature);
    }

    private static Transaction createTransaction(int tick, long amount, byte[] sourcePublicKey, byte[] destinationPublicKey, short inputType, byte[] extraData) {
        Objects.requireNonNull(extraData, "Extra data cannot be null. Pass byte[0] instead.");
        short inputSize = (short)extraData.length;
        return ((Transaction.TransactionBuilder)((Transaction.TransactionBuilder)((Transaction.TransactionBuilder)((Transaction.TransactionBuilder)((Transaction.TransactionBuilder)((Transaction.TransactionBuilder)((Transaction.TransactionBuilder)Transaction.builder().sourcePublicKey(sourcePublicKey)).destinationPublicKey(destinationPublicKey)).amount(amount)).inputType(inputType)).inputSize(inputSize)).extraData(extraData)).tick(tick)).build();
    }

    private byte[] createSignatureWithSubSeed(byte[] subSeed, byte[] publicKey, Transaction transaction) {
        byte[] txDigest = KangarooTwelve.hash(transaction.toBytes(), 32);
        return this.signing.sign(subSeed, publicKey, txDigest);
    }

    private byte[] createSignatureWithNonceK(byte[] nonceK, byte[] publicKey, Transaction transaction) {
        byte[] txDigest = KangarooTwelve.hash(transaction.toBytes(), 32);
        return this.signing.signWithNonceK(nonceK, publicKey, txDigest);
    }

    private SignedTransaction createSignedTransaction(Transaction transaction, byte[] signature) {
        byte[] transactionBytes = transaction.toBytes();
        return ((SignedTransaction.SignedTransactionBuilder)((SignedTransaction.SignedTransactionBuilder)((SignedTransaction.SignedTransactionBuilder)SignedTransaction.builder().transaction(transaction)).signature(signature)).transactionHash(this.calculateTransactionHash(ArrayUtils.addAll((byte[])transactionBytes, (byte[])signature)))).build();
    }

    public String calculateTransactionHash(SignedTransaction transaction) {
        return this.calculateTransactionHash(transaction.toBytes());
    }

    private String calculateTransactionHash(byte[] signedTransactionBytes) {
        byte[] signedTxDigest = KangarooTwelve.hash(signedTransactionBytes, 32);
        return this.identityUtil.getTransactionHash(signedTxDigest);
    }

    public boolean verify(SignedTransaction signedTransaction) {
        Objects.requireNonNull(signedTransaction.getTransaction());
        byte[] transactionBytes = signedTransaction.getTransaction().toBytes();
        byte[] signedTxDigest = KangarooTwelve.hash(transactionBytes, 32);
        byte[] sourcePublicKey = signedTransaction.getTransaction().getSourcePublicKey();
        byte[] signature = signedTransaction.getSignature();
        return this.signing.verify(sourcePublicKey, signedTxDigest, signature);
    }
}

