/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.rescal.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import won.matcher.rescal.config.RescalMatcherConfig;
import won.matcher.rescal.service.HintReader;
import won.matcher.service.common.event.BulkHintEvent;
import won.matcher.service.common.event.HintEvent;
import won.matcher.utils.tensor.TensorEntry;
import won.matcher.utils.tensor.TensorEntryAllGenerator;
import won.matcher.utils.tensor.TensorEntryTokenizer;
import won.matcher.utils.tensor.TensorMatchingData;

@Component
@Scope(value="prototype")
public class RescalMatcherActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private long lastQueryDate = Long.MIN_VALUE;
    private TensorMatchingData rescalInputData = new TensorMatchingData();
    private static final String TICK = "tick";
    private ActorRef pubSubMediator;
    @Autowired
    private HintReader hintReader;
    @Autowired
    private RescalMatcherConfig config;

    public void preStart() throws IOException {
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
        this.getContext().system().scheduler().schedule(FiniteDuration.Zero(), this.config.getExecutionDuration(), this.getSelf(), (Object)TICK, (ExecutionContext)this.getContext().dispatcher(), null);
    }

    public void onReceive(Object o) throws Exception {
        if (o.equals(TICK)) {
            this.executeRescalAlgorithm();
        } else {
            this.unhandled(o);
        }
    }

    private void executeRescalAlgorithm() throws IOException, InterruptedException {
        String line;
        this.log.info("start processing (every {} minutes) ...", (Object)this.config.getExecutionDuration());
        long queryDate = System.currentTimeMillis();
        this.log.info("query needs and connections from rdf store '{}' from date '{}' to date '{}'", (Object)this.config.getSparqlEndpoint(), (Object)this.lastQueryDate, (Object)queryDate);
        TensorEntryAllGenerator tensorEntryAllGenerator = new TensorEntryAllGenerator("queries/attribute", this.config.getSparqlEndpoint(), this.lastQueryDate, queryDate);
        TensorEntryTokenizer tokenizer = new TensorEntryTokenizer(tensorEntryAllGenerator.generateTensorEntries());
        Collection tensorEntries = tokenizer.generateTensorEntries();
        for (TensorEntry entry : tensorEntries) {
            this.rescalInputData.addNeedAttribute(entry);
        }
        tensorEntryAllGenerator = new TensorEntryAllGenerator("queries/connection", this.config.getSparqlEndpoint(), this.lastQueryDate, queryDate);
        tensorEntries = tensorEntryAllGenerator.generateTensorEntries();
        for (TensorEntry entry : tensorEntries) {
            this.rescalInputData.addNeedConnection(entry.getNeedUri(), entry.getValue(), true);
        }
        this.log.info("number of needs in tensor: {}", (Object)this.rescalInputData.getNeeds().size());
        this.log.info("number of attributes in tensor: {}", (Object)this.rescalInputData.getAttributes().size());
        this.log.info("number of connections in tensor: {}", (Object)this.rescalInputData.getNumberOfConnections());
        this.log.info("number of slices in tensor: {}", (Object)this.rescalInputData.getSlices().size());
        if (!this.rescalInputData.isValidTensor()) {
            this.log.info("not enough tensor data available for execution yet, wait for next execution!");
            return;
        }
        this.log.info("write rescal input data to folder: {}", (Object)this.config.getExecutionDirectory());
        TensorMatchingData cleanedTensorData = this.rescalInputData.writeCleanedOutputFiles(this.config.getExecutionDirectory());
        int tensorSize = cleanedTensorData.getTensorDimensions()[0];
        if ((long)(this.rescalInputData.getNeeds().size() + this.rescalInputData.getAttributes().size()) < this.config.getRescalRank()) {
            this.log.info("Do not start rescal algorithm since tensor size (number of needs + number of attributes) = {} is smaller than rank parameter {}.", (Object)tensorSize, (Object)this.config.getRescalRank());
            return;
        }
        String pythonCall = "python " + this.config.getPythonScriptDirectory() + "/rescal-matcher.py -inputfolder " + this.config.getExecutionDirectory() + " -outputfolder " + this.config.getExecutionDirectory() + "/output -rank " + this.config.getRescalRank() + " -threshold " + this.config.getRescalThreshold();
        this.log.info("execute python script: " + pythonCall);
        Process pythonProcess = Runtime.getRuntime().exec(pythonCall);
        BufferedReader in = new BufferedReader(new InputStreamReader(pythonProcess.getInputStream()));
        while ((line = in.readLine()) != null) {
            this.log.info(line);
        }
        in.close();
        BufferedReader err = new BufferedReader(new InputStreamReader(pythonProcess.getErrorStream()));
        while ((line = err.readLine()) != null) {
            this.log.warning(line);
        }
        err.close();
        int returnCode = pythonProcess.waitFor();
        if (returnCode != 0) {
            this.log.error("rescal python call returned error code: " + returnCode);
            return;
        }
        BulkHintEvent hintsEvent = this.hintReader.readHints(this.rescalInputData);
        int numHints = hintsEvent == null || hintsEvent.getHintEvents() == null ? 0 : hintsEvent.getHintEvents().size();
        this.log.info("loaded {} hints into bulk hint event and publish", (Object)numHints);
        if (numHints > 0) {
            StringBuilder builder = new StringBuilder();
            for (HintEvent hint : hintsEvent.getHintEvents()) {
                builder.append("\n- " + hint);
            }
            this.log.info(builder.toString());
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(hintsEvent.getClass().getName(), (Object)hintsEvent), this.getSelf());
        }
        this.lastQueryDate = queryDate;
    }
}

