/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.rescal.config;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@Configuration
@PropertySource(value={"file:${WON_CONFIG_DIR}/matcher-rescal.properties"})
public class RescalMatcherConfig {
    @Value(value="${matcher.rescal.uri.sparql.endpoint}")
    private String sparqlEndpoint;
    @Value(value="${matcher.rescal.uri.public}")
    private String publicMatcherUri;
    @Value(value="${matcher.rescal.executionDir}")
    private String executionDirectory;
    @Value(value="${matcher.rescal.pythonScriptDir}")
    private String pythonScriptDirectory;
    @Value(value="${matcher.rescal.executionDurationMinutes}")
    private long executionDuration;
    @Value(value="${matcher.rescal.threshold}")
    private double rescalThreshold;
    @Value(value="${matcher.rescal.rank}")
    private long rescalRank;

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public void setSparqlEndpoint(String sparqlEndpoint) {
        this.sparqlEndpoint = sparqlEndpoint;
    }

    public String getPublicMatcherUri() {
        return this.publicMatcherUri;
    }

    public void setPublicMatcherUri(String publicMatcherUri) {
        this.publicMatcherUri = publicMatcherUri;
    }

    public String getExecutionDirectory() {
        return this.executionDirectory;
    }

    public void setExecutionDirectory(String executionDirectory) {
        this.executionDirectory = executionDirectory;
    }

    public String getPythonScriptDirectory() {
        return this.pythonScriptDirectory;
    }

    public void setPythonScriptDirectory(String pythonScriptDirectory) {
        this.pythonScriptDirectory = pythonScriptDirectory;
    }

    public FiniteDuration getExecutionDuration() {
        return Duration.create((long)this.executionDuration, (TimeUnit)TimeUnit.MINUTES);
    }

    public void setExecutionDuration(long executionDuration) {
        this.executionDuration = executionDuration;
    }

    public double getRescalThreshold() {
        return this.rescalThreshold;
    }

    public void setRescalThreshold(double rescalThreshold) {
        this.rescalThreshold = rescalThreshold;
    }

    public long getRescalRank() {
        return this.rescalRank;
    }

    public void setRescalRank(long rescalRank) {
        this.rescalRank = rescalRank;
    }
}

