/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.rescal.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.la4j.matrix.SparseMatrix;
import org.la4j.matrix.functor.MatrixProcedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.matcher.rescal.config.RescalMatcherConfig;
import won.matcher.service.common.event.BulkHintEvent;
import won.matcher.service.common.event.HintEvent;
import won.matcher.utils.tensor.TensorMatchingData;

@Component
public class HintReader {
    private static final Logger log = LoggerFactory.getLogger(HintReader.class);
    @Autowired
    private RescalMatcherConfig config;

    public BulkHintEvent readHints(TensorMatchingData matchingData) throws IOException {
        SparseMatrix hintMatrix;
        ArrayList<String> needHeaders = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(this.config.getExecutionDirectory() + "/" + "headers.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
        String line = null;
        int i = 0;
        while ((line = br.readLine()) != null) {
            needHeaders.add(i, line);
            ++i;
        }
        br.close();
        fis = new FileInputStream(this.config.getExecutionDirectory() + "/output/hints.mtx");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
        StringBuffer stringBuffer = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("%%MatrixMarket")) {
                if (!line.contains("row-major") || !line.contains("column-major")) {
                    stringBuffer.append(line).append(" row-major\n");
                    continue;
                }
                stringBuffer.append(line).append("\n");
                continue;
            }
            if (line.startsWith("%")) continue;
            stringBuffer.append(line).append("\n");
        }
        String hintMatrixString = stringBuffer.toString();
        try {
            hintMatrix = SparseMatrix.fromMatrixMarket((String)hintMatrixString);
        }
        catch (Exception e) {
            log.warn("Cannot load hint matrix file. This can happen if no hints were created");
            log.debug("Exception was: ", (Throwable)e);
            return null;
        }
        BulkHintEventMatrixProcedure hintProcedure = new BulkHintEventMatrixProcedure(needHeaders, matchingData);
        hintMatrix.eachNonZero((MatrixProcedure)hintProcedure);
        return hintProcedure.getBulkHintEvent();
    }

    private class BulkHintEventMatrixProcedure
    implements MatrixProcedure {
        private BulkHintEvent hints = new BulkHintEvent();
        private ArrayList<String> needUris;
        private TensorMatchingData matchingData;

        public BulkHintEventMatrixProcedure(ArrayList<String> needUris, TensorMatchingData matchingData) {
            this.needUris = needUris;
            this.matchingData = matchingData;
        }

        public void apply(int i, int j, double value) {
            String needUri1 = this.needUris.get(i);
            String needUri2 = this.needUris.get(j);
            List matchingDataNeeds = this.matchingData.getNeeds();
            if (needUri1 == null || needUri2 == null || !matchingDataNeeds.contains(needUri1) || !matchingDataNeeds.contains(needUri2)) {
                throw new IllegalStateException("MatchingData does not contain needs with URI " + needUri1 + " or " + needUri2);
            }
            String fromWonNodeUri = this.matchingData.getFirstAttributeOfNeed(needUri1, "wonNodeUri");
            String toWonNodeUri = this.matchingData.getFirstAttributeOfNeed(needUri2, "wonNodeUri");
            HintEvent hint = new HintEvent(fromWonNodeUri, needUri1, toWonNodeUri, needUri2, HintReader.this.config.getPublicMatcherUri(), value);
            this.hints.addHintEvent(hint);
        }

        public BulkHintEvent getBulkHintEvent() {
            return this.hints;
        }
    }
}

