/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.camel.routes;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class MatcherApplicationListenerRouteBuilder
extends RouteBuilder {
    private List<String> endpoints;
    private URI brokerUri;

    public MatcherApplicationListenerRouteBuilder(CamelContext camelContext, Set<String> endpoints, URI remoteEndpoint) {
        super(camelContext);
        ArrayList<String> endpointsList = new ArrayList<String>();
        Iterator<String> iter = endpoints.iterator();
        while (iter.hasNext()) {
            for (int i = 0; i < endpoints.size(); ++i) {
                String endpoint = "activemq" + remoteEndpoint.toString().replaceAll("[/:]", "") + ":topic:" + iter.next();
                endpointsList.add(endpoint);
            }
        }
        this.endpoints = endpointsList;
        this.brokerUri = remoteEndpoint;
    }

    public void configure() throws Exception {
        for (int i = 0; i < this.endpoints.size(); ++i) {
            ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from(this.endpoints.get(i)).routeId("Node2MatcherRoute" + this.brokerUri + i).choice().when(this.header("methodName").isEqualTo((Object)"atomCreated")).to("bean:matcherProtocolMatcherServiceJMSBased?method=atomCreated")).when(this.header("methodName").isEqualTo((Object)"atomModified")).to("bean:matcherProtocolMatcherServiceJMSBased?method=atomModified")).when(this.header("methodName").isEqualTo((Object)"atomActivated")).to("bean:matcherProtocolMatcherServiceJMSBased?method=atomActivated")).when(this.header("methodName").isEqualTo((Object)"atomDeactivated")).to("bean:matcherProtocolMatcherServiceJMSBased?method=atomDeactivated")).otherwise().to("log: cannot handle incoming message: value of 'in' header 'methodName' not supported.");
        }
    }
}

