/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.cli;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import won.matcher.protocol.impl.MatcherProtocolAtomServiceClient;
import won.protocol.exception.IllegalMessageForAtomStateException;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.WonMessageBuilderException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageBuilder;
import won.protocol.message.WonMessageDirection;
import won.protocol.service.WonNodeInformationService;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

public class MatcherCLI
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MatcherProtocolAtomServiceClient client;
    @Autowired
    private WonNodeInformationService wonNodeInformationService;
    @Autowired
    private LinkedDataSource linkedDataSource;

    public void run(String ... args) throws Exception {
        String atom1 = "http://localhost:8080/won/resource/atom/1";
        String atom2 = "http://localhost:8080/won/resource/atom/2";
        String org = "http://localhost:8080/matcher";
        double score = 1.0;
        block19: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-h": {
                    System.out.println("USAGE: java MatcherCLI [-n1 atom1] [-n2 atom2] [-o originator] [-s score] [-h]");
                    System.exit(0);
                }
                case "-n1": {
                    atom1 = args[++i];
                    continue block19;
                }
                case "-n2": {
                    atom2 = args[++i];
                    continue block19;
                }
                case "-o": {
                    org = args[++i];
                    continue block19;
                }
                case "-s": {
                    score = Double.parseDouble(args[++i]);
                }
            }
        }
        try {
            this.client.hint(new URI(atom1), new URI(atom2), score, new URI(org), null, this.createWonMessage(URI.create(atom1), URI.create(atom2), score, URI.create(org)));
        }
        catch (URISyntaxException e) {
            logger.error("Exception caught:", (Throwable)e);
        }
        catch (IllegalMessageForAtomStateException e) {
            logger.error("Exception caught:", (Throwable)e);
        }
        catch (NoSuchAtomException e) {
            logger.error("Exception caught:", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setClient(MatcherProtocolAtomServiceClient client) {
        this.client = client;
    }

    private WonMessage createWonMessage(URI atomURI, URI otherAtomURI, double score, URI originator) throws WonMessageBuilderException {
        URI wonNode = WonLinkedDataUtils.getWonNodeURIForAtomOrConnection((URI)atomURI, (Dataset)this.linkedDataSource.getDataForResource(atomURI));
        return WonMessageBuilder.setMessagePropertiesForHintToAtom((URI)this.wonNodeInformationService.generateEventURI(wonNode), (URI)atomURI, (URI)wonNode, (URI)otherAtomURI, (URI)originator, (double)score).setWonMessageDirection(WonMessageDirection.FROM_EXTERNAL).build();
    }
}

