/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.protocol.impl;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.matcher.protocol.MatcherProtocolMatcherService;
import won.matcher.protocol.MatcherProtocolMatcherServiceCallback;
import won.matcher.protocol.NopMatcherProtocolMatcherServiceCallback;

public class MatcherProtocolMatcherServiceImpl
implements MatcherProtocolMatcherService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private MatcherProtocolMatcherServiceCallback matcherServiceCallback = new NopMatcherProtocolMatcherServiceCallback();

    @Override
    public void onMatcherRegistration(URI wonNodeUri) {
        this.logger.debug("matcher registration complete on {} ", (Object)wonNodeUri);
        this.matcherServiceCallback.onRegistered(wonNodeUri);
    }

    @Override
    public void onNewAtom(URI wonNodeURI, URI atomURI, Dataset content) {
        this.logger.debug("matcher from atom: atom created event for atomURI {}", (Object)atomURI);
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        this.matcherServiceCallback.onNewAtom(wonNodeURI, atomURI, content);
    }

    @Override
    public void onAtomModified(URI wonNodeURI, URI atomURI) {
        this.logger.debug("matcher from atom: atom modified event for atomURI {}", (Object)atomURI);
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        this.matcherServiceCallback.onAtomModified(wonNodeURI, atomURI);
    }

    @Override
    public void onAtomActivated(URI wonNodeURI, URI atomURI) {
        this.logger.debug("matcher from atom: atom activated event for atomURI {}", (Object)atomURI);
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        this.matcherServiceCallback.onAtomActivated(wonNodeURI, atomURI);
    }

    @Override
    public void onAtomDeactivated(URI wonNodeURI, URI atomURI) {
        this.logger.debug("matcher from atom: atom deactivated event for atomURI {}", (Object)atomURI);
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        this.matcherServiceCallback.onAtomDeactivated(wonNodeURI, atomURI);
    }
}

