/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.protocol.impl;

import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.apache.camel.Body;
import org.apache.camel.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.matcher.component.MatcherNodeURISource;
import won.matcher.protocol.MatcherProtocolMatcherService;
import won.matcher.protocol.impl.MatcherProtocolCommunicationServiceImpl;
import won.protocol.exception.CamelConfigurationFailedException;
import won.protocol.jms.MatcherProtocolCommunicationService;
import won.protocol.util.RdfUtils;

public class MatcherProtocolMatcherServiceImplJMSBased {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MatcherNodeURISource matcherNodeURISource;
    @Autowired
    MatcherProtocolMatcherService delegate;
    private MatcherProtocolCommunicationServiceImpl matcherProtocolCommunicationService;

    public void atomCreated(@Header(value="wonNodeURI") String wonNodeURI, @Header(value="atomURI") String atomURI, @Body String content) {
        this.logger.debug("new atom received: {} with content {}", (Object)atomURI, (Object)content);
        this.delegate.onNewAtom(URI.create(wonNodeURI), URI.create(atomURI), RdfUtils.toDataset((String)content));
    }

    public void atomModified(@Header(value="wonNodeURI") String wonNodeURI, @Header(value="atomURI") String atomURI) {
        this.logger.debug("atom modified message received: {}", (Object)atomURI);
        this.delegate.onAtomModified(URI.create(wonNodeURI), URI.create(atomURI));
    }

    public void atomActivated(@Header(value="wonNodeURI") String wonNodeURI, @Header(value="atomURI") String atomURI) {
        this.logger.debug("atom activated message received: {}", (Object)atomURI);
        this.delegate.onAtomActivated(URI.create(wonNodeURI), URI.create(atomURI));
    }

    public void atomDeactivated(@Header(value="wonNodeURI") String wonNodeURI, @Header(value="atomURI") String atomURI) {
        this.logger.debug("atom deactivated message received: {}", (Object)atomURI);
        this.delegate.onAtomDeactivated(URI.create(wonNodeURI), URI.create(atomURI));
    }

    private Set<String> configureMatcherProtocolOutTopics(URI nodeUri) throws CamelConfigurationFailedException {
        Set<String> remoteTopics = this.matcherProtocolCommunicationService.getMatcherProtocolOutTopics(nodeUri);
        this.matcherProtocolCommunicationService.addRemoteTopicListeners(remoteTopics, nodeUri);
        this.delegate.onMatcherRegistration(nodeUri);
        return remoteTopics;
    }

    public void register(URI wonNodeURI) throws CamelConfigurationFailedException {
        this.configureMatcherProtocolOutTopics(wonNodeURI);
    }

    public void register() {
        this.logger.debug("registering owner application on application event");
        try {
            new Thread(){

                @Override
                public void run() {
                    Iterator iter = MatcherProtocolMatcherServiceImplJMSBased.this.matcherNodeURISource.getNodeURIIterator();
                    while (iter.hasNext()) {
                        URI wonNodeUri = (URI)iter.next();
                        try {
                            MatcherProtocolMatcherServiceImplJMSBased.this.configureMatcherProtocolOutTopics(wonNodeUri);
                        }
                        catch (Exception e) {
                            MatcherProtocolMatcherServiceImplJMSBased.this.logger.warn("Could not get topic lists from default node {}", (Object)wonNodeUri, (Object)e);
                        }
                    }
                }
            }.start();
        }
        catch (Exception e) {
            this.logger.warn("could not register", (Throwable)e);
        }
    }

    public MatcherProtocolCommunicationService getMatcherProtocolCommunicationService() {
        return this.matcherProtocolCommunicationService;
    }

    public void setMatcherProtocolCommunicationService(MatcherProtocolCommunicationServiceImpl matcherProtocolCommunicationService) {
        this.matcherProtocolCommunicationService = matcherProtocolCommunicationService;
    }

    public void setMatcherNodeURISource(MatcherNodeURISource matcherNodeURISource) {
        this.matcherNodeURISource = matcherNodeURISource;
    }
}

