/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.service.RegistrationClient;
import won.cryptography.service.RegistrationRestClientHttps;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.jms.ActiveMQService;
import won.protocol.jms.AtomProtocolCamelConfigurator;
import won.protocol.jms.AtomProtocolCommunicationService;
import won.protocol.jms.CamelConfiguration;
import won.protocol.jms.CamelConfigurator;

public class AtomProtocolCommunicationServiceImpl
implements AtomProtocolCommunicationService {
    @Autowired
    private AtomProtocolCamelConfigurator atomProtocolCamelConfigurator;
    @Autowired
    private ActiveMQService activeMQService;
    private RegistrationClient registrationClient;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setRegistrationClient(RegistrationRestClientHttps registrationClient) {
        this.registrationClient = registrationClient;
    }

    public synchronized CamelConfiguration configureCamelEndpoint(URI wonNodeUri) throws Exception {
        CamelConfiguration camelConfiguration = new CamelConfiguration();
        logger.debug("ensuring camel is configured for remote wonNodeUri {}", (Object)wonNodeUri);
        URI remoteNodeBrokerUri = this.activeMQService.getBrokerEndpoint(wonNodeUri);
        if (this.atomProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(remoteNodeBrokerUri) != null) {
            logger.debug("broker component name is already known");
            camelConfiguration.setEndpoint(this.atomProtocolCamelConfigurator.getEndpoint(wonNodeUri));
            camelConfiguration.setBrokerComponentName(this.atomProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(remoteNodeBrokerUri));
        } else {
            logger.debug("broker component name unknown - setting up a new component for the remote broker");
            URI resourceUri = wonNodeUri;
            URI brokerUri = remoteNodeBrokerUri;
            String atomProtocolQueueName = this.activeMQService.getProtocolQueueNameWithResource(resourceUri);
            this.registrationClient.register(wonNodeUri.toString());
            String endpoint = this.atomProtocolCamelConfigurator.configureCamelEndpointForAtomUri(resourceUri, brokerUri, atomProtocolQueueName);
            camelConfiguration.setEndpoint(endpoint);
            camelConfiguration.setBrokerComponentName(this.atomProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(brokerUri));
            ActiveMQComponent activeMQComponent = (ActiveMQComponent)this.atomProtocolCamelConfigurator.getCamelContext().getComponent(this.atomProtocolCamelConfigurator.getBrokerComponentNameWithBrokerUri(brokerUri));
            logger.info("ActiveMQ Service Status : {}", (Object)activeMQComponent.getStatus().toString());
            activeMQComponent.start();
        }
        return camelConfiguration;
    }

    public URI getBrokerUri(URI resourceUri) throws NoSuchConnectionException {
        return this.activeMQService.getBrokerEndpoint(resourceUri);
    }

    public ActiveMQService getActiveMQService() {
        return this.activeMQService;
    }

    public void setActiveMQService(ActiveMQService activeMQService) {
        this.activeMQService = activeMQService;
    }

    public CamelConfigurator getProtocolCamelConfigurator() {
        return this.atomProtocolCamelConfigurator;
    }
}

