/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageReactionProcessor;
import won.protocol.message.WonMessage;

@Component
@FixedMessageReactionProcessor(direction="https://w3id.org/won/message#FromOwner", messageType="https://w3id.org/won/message#ActivateMessage")
public class ActivateAtomMessageReactionProcessor
extends AbstractCamelProcessor {
    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        URI recipientAtomURI = wonMessage.getRecipientAtomURI();
        if (recipientAtomURI == null) {
            throw new IllegalArgumentException("recipientAtomURI is not set");
        }
        this.matcherProtocolMatcherClient.atomActivated(recipientAtomURI, wonMessage);
    }
}

