/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.lang.invoke.MethodHandles;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;

@Component
@FixedMessageProcessor(direction="https://w3id.org/won/message#FromOwner", messageType="https://w3id.org/won/message#CloseMessage")
public class CloseMessageFromOwnerProcessor
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        logger.debug("CLOSE received from the owner side for connection {}-{}", (Object)wonMessage.getSenderSocketURI(), (Object)wonMessage.getRecipientSocketURI());
        Connection con = WonCamelHelper.getConnectionRequired(exchange, this.connectionService);
        ConnectionState originalState = con.getState();
        con = this.connectionService.closeFromOwner(wonMessage);
        if (originalState == ConnectionState.SUGGESTED) {
            WonCamelHelper.suppressMessageToNode(exchange);
        }
    }
}

