/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.lang.invoke.MethodHandles;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.model.Connection;

@Component
@FixedMessageProcessor(direction="https://w3id.org/won/message#FromSystem", messageType="https://w3id.org/won/message#CloseMessage")
public class CloseMessageFromSystemProcessor
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void process(Exchange exchange) throws Exception {
        WonMessage wonMessage = WonCamelHelper.getMessageRequired(exchange);
        Connection con = this.connectionService.closeFromSystem(wonMessage);
        if (con.getTargetConnectionURI() == null) {
            WonCamelHelper.suppressMessageToNode(exchange);
        }
    }
}

