/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageReactionProcessor;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.ConnectBuilder;
import won.protocol.message.builder.WonMessageBuilder;

@Component
@FixedMessageReactionProcessor(direction="https://w3id.org/won/message#FromExternal", messageType="https://w3id.org/won/message#ConnectMessage")
public class ConnectMessageFromNodeReactionProcessor
extends AbstractCamelProcessor {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        if (this.connectionService.shouldSendAutoOpenForConnect(wonMessage)) {
            this.sendAutoOpenForConnect(wonMessage);
        }
    }

    private void sendAutoOpenForConnect(WonMessage connectMessageToReactTo) {
        URI fromWonNodeURI = connectMessageToReactTo.getRecipientNodeURI();
        WonMessage msg = ((ConnectBuilder)((ConnectBuilder)((ConnectBuilder)WonMessageBuilder.connect().sockets().reactingTo(connectMessageToReactTo)).direction().fromSystem()).content().text("Connection request accepted automatically by WoN node")).build();
        this.logger.info("sending auto-open for connection {}-{}, reacting to connect", (Object)msg.getSenderSocketURI(), (Object)msg.getRecipientSocketURI());
        this.camelWonMessageService.sendSystemMessage(msg);
    }
}

