/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.model.Connection;

@Component
@FixedMessageProcessor(direction="https://w3id.org/won/message#FromOwner", messageType="https://w3id.org/won/message#ConnectMessage")
public class ConnectMessageFromOwnerProcessor
extends AbstractCamelProcessor {
    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        Connection con = this.connectionService.connectFromOwner(wonMessage);
        WonCamelHelper.putParentURI(exchange, con.getConnectionURI());
        WonCamelHelper.putConnectionURI(exchange, con.getConnectionURI());
    }
}

