/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.util.Optional;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageReactionProcessor;
import won.node.camel.processor.general.ConnectionStateChangeBuilder;
import won.node.camel.service.WonCamelHelper;
import won.node.service.nodebehaviour.ConnectionStateChange;
import won.protocol.message.WonMessage;
import won.protocol.model.Atom;
import won.protocol.model.Connection;

@Component
@FixedMessageReactionProcessor
public class ConnectionStateChangeReactionProcessor
extends AbstractCamelProcessor {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) throws Exception {
        WonMessage wonMessage = (WonMessage)exchange.getIn().getHeader("won.message");
        String msgTypeDir = "[message type: " + wonMessage.getMessageType() + ", direction: " + wonMessage.getEnvelopeType() + "]";
        ConnectionStateChangeBuilder stateChangeBuilder = (ConnectionStateChangeBuilder)exchange.getIn().getHeader("won.connectionStateChangeBuilder");
        if (stateChangeBuilder == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("no stateChangeBuilder found in exchange header, cannot check for state change " + msgTypeDir);
            }
            return;
        }
        Optional<Connection> con = WonCamelHelper.getConnection(exchange, this.connectionService);
        if (con.isPresent() && !stateChangeBuilder.canBuild()) {
            stateChangeBuilder.newState(con.get().getState());
        }
        if (stateChangeBuilder.canBuild()) {
            ConnectionStateChange connectionStateChange = stateChangeBuilder.build();
            Atom atom = this.atomService.getAtomRequired(con.get().getAtomURI());
            if (connectionStateChange.isConnect() || connectionStateChange.isDisconnect()) {
                this.matcherProtocolMatcherClient.atomModified(atom.getAtomURI(), null);
                this.logger.debug("matchers notified of connection state change {}", (Object)msgTypeDir);
            } else {
                this.logger.debug("no relevant connection state change, not notifying matchers {}", (Object)msgTypeDir);
            }
        } else {
            this.logger.debug("Could not collect ConnectionStateChange information, not checking for state change {}", (Object)msgTypeDir);
        }
    }
}

