/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.lang.invoke.MethodHandles;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.model.Atom;

@Service
@FixedMessageProcessor(direction="https://w3id.org/won/message#FromOwner", messageType="https://w3id.org/won/message#CreateMessage")
public class CreateAtomMessageProcessor
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        Atom atom = this.atomService.createAtom(wonMessage);
        WonCamelHelper.putParentURI(exchange, atom.getAtomURI());
        String ownerApplicationID = message.getHeader("won.ownerApplicationId").toString();
        atom = this.atomService.authorizeOwnerApplicationForAtom(ownerApplicationID, atom);
        this.atomService.lockAtom(atom.getAtomURI());
    }
}

