/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.lang.invoke.MethodHandles;
import org.apache.camel.Exchange;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageReactionProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.AtomCreatedNotificationBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.message.processor.impl.SignatureAddingWonMessageProcessor;
import won.protocol.model.Atom;
import won.protocol.repository.AtomRepository;

@Service
@FixedMessageReactionProcessor(direction="https://w3id.org/won/message#FromOwner", messageType="https://w3id.org/won/message#CreateMessage")
public class CreateAtomMessageReactionProcessor
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    AtomRepository atomRepository;
    @Autowired
    SignatureAddingWonMessageProcessor signatureAdder;

    public void process(Exchange exchange) throws Exception {
        Atom atom = this.atomService.getAtomForMessageRequired(WonCamelHelper.getMessageRequired(exchange), WonCamelHelper.getDirectionRequired(exchange));
        try {
            WonMessage newAtomNotificationMessage = this.makeAtomCreatedMessageForMatcher(atom);
            this.matcherProtocolMatcherClient.atomCreated(atom.getAtomURI(), ModelFactory.createDefaultModel(), this.signatureAdder.process(newAtomNotificationMessage));
        }
        catch (Exception e) {
            logger.warn("could not create AtomCreatedNotification", (Throwable)e);
        }
    }

    private WonMessage makeAtomCreatedMessageForMatcher(Atom atom) throws NoSuchAtomException {
        return ((AtomCreatedNotificationBuilder)WonMessageBuilder.atomCreatedNotification().atom(atom.getAtomURI())).build();
    }
}

