/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.net.URI;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageReactionProcessor;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.CloseBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.model.Atom;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;

@Component
@FixedMessageReactionProcessor(direction="https://w3id.org/won/message#FromSystem", messageType="https://w3id.org/won/message#DeactivateMessage")
public class DeactivateAtomMessageFromSystemReactionProcessor
extends AbstractCamelProcessor {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    EntityManager entityManager;

    public void process(Exchange exchange) throws Exception {
        WonMessage wonMessage = (WonMessage)exchange.getIn().getHeader("won.message");
        URI recipientAtomURI = wonMessage.getRecipientAtomURI();
        this.logger.debug("DEACTIVATING atom. atomURI:{}", (Object)recipientAtomURI);
        if (recipientAtomURI == null) {
            throw new WonMessageProcessingException("recipientAtomURI is not set");
        }
        Atom atom = this.atomService.getAtomRequired(recipientAtomURI);
        this.matcherProtocolMatcherClient.atomDeactivated(atom.getAtomURI(), wonMessage);
        List conns = this.connectionRepository.findByAtomURIAndNotStateForUpdate(atom.getAtomURI(), ConnectionState.CLOSED);
        for (Connection con : conns) {
            this.entityManager.refresh((Object)con);
            this.closeConnection(atom, con);
        }
    }

    public void closeConnection(Atom atom, Connection con) {
        WonMessage message = ((CloseBuilder)((CloseBuilder)((CloseBuilder)WonMessageBuilder.close().direction().fromSystem()).sockets().sender(con.getSocketURI()).recipient(con.getTargetSocketURI())).content().text("Closed because Atom was deactivated")).build();
        this.camelWonMessageService.sendSystemMessage(message);
    }
}

