/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.lang.invoke.MethodHandles;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;

@Component
@FixedMessageProcessor(direction="https://w3id.org/won/message#FromExternal", messageType="https://w3id.org/won/message#FailureResponse")
public class FailureResponseFromExternalProcessor
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void process(Exchange exchange) throws Exception {
        WonMessage responseMessage = WonCamelHelper.getMessageRequired(exchange);
        assert (responseMessage != null) : "wonMessage header must not be null";
        WonMessageType responseToType = responseMessage.getRespondingToMessageType();
        logger.warn("TODO: forward to owners and delete the whole delivery chain");
        if (WonMessageType.CONNECT.equals((Object)responseToType)) {
            logger.warn("The remote end responded with a failure message. Our behaviour is now undefined.");
        }
    }
}

