/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.net.URI;
import java.util.List;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageReactionProcessor;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.ChangeNotificationBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.model.Atom;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;

@Component
@FixedMessageReactionProcessor(direction="https://w3id.org/won/message#FromOwner", messageType="https://w3id.org/won/message#ReplaceMessage")
public class ReplaceAtomMessageFromOwnerReactionProcessor
extends AbstractCamelProcessor {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) throws Exception {
        WonMessage wonMessage = (WonMessage)exchange.getIn().getHeader("won.message");
        URI atomURI = wonMessage.getSenderAtomURI();
        if (atomURI == null) {
            throw new IllegalArgumentException("senderAtomURI not found!");
        }
        this.logger.debug("Reacting to atom replacement. AtomURI:{}", (Object)atomURI);
        Atom atom = this.atomService.getAtomRequired(atomURI);
        this.matcherProtocolMatcherClient.atomModified(atom.getAtomURI(), wonMessage);
        List conns = this.connectionRepository.findByAtomURIAndState(atom.getAtomURI(), ConnectionState.CONNECTED);
        for (Connection con : conns) {
            this.sendChangeNotificationMessage(atom, con);
        }
    }

    private void sendChangeNotificationMessage(Atom atom, Connection con) {
        WonMessage message = ((ChangeNotificationBuilder)((ChangeNotificationBuilder)WonMessageBuilder.changeNotificatin().direction().fromSystem()).sockets().sender(con.getSocketURI()).recipient(con.getTargetSocketURI())).build();
        this.camelWonMessageService.sendSystemMessage(message);
    }
}

