/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageReactionProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.ConnectionMessageBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;
import won.protocol.util.LoggingUtils;
import won.protocol.util.Prefixer;
import won.protocol.util.RdfUtils;

@Component
@FixedMessageReactionProcessor(direction="https://w3id.org/won/message#FromExternal", messageType="https://w3id.org/won/message#ConnectionMessage")
public class SendMessageFromNodeReactionProcessor
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        Objects.nonNull(message);
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        Objects.nonNull(wonMessage);
        logger.debug("reacting to ConnectionMessage {}", (Object)wonMessage.getMessageURI());
        List injectTargets = wonMessage.getInjectIntoConnectionURIs();
        if (injectTargets.isEmpty()) {
            logger.debug("no injection attempted - nothing to do for us here");
            return;
        }
        injectTargets.forEach(target -> {
            try {
                if (Objects.equals(target, WonCamelHelper.getConnectionURI(exchange))) {
                    return;
                }
                Optional<Connection> con = this.connectionService.getConnection((URI)target);
                if (con.isPresent()) {
                    if (con.get().getAtomURI().equals(wonMessage.getRecipientAtomURI())) {
                        this.forward(wonMessage, con.get());
                    }
                } else {
                    logger.debug("Could not inject message into connection {}: no connection found", target);
                }
            }
            catch (Exception e) {
                LoggingUtils.logMessageAsInfoAndStacktraceAsDebug((Logger)logger, (Exception)e, (String)"Could not forward message {}", (Object[])new Object[]{wonMessage.getMessageURI()});
            }
        });
    }

    public void forward(WonMessage wonMessage, Connection conToSendTo) {
        if (conToSendTo.getState() != ConnectionState.CONNECTED) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("injecting message {} received from atom {} to connection {}", new Object[]{wonMessage.getMessageURI(), wonMessage.getSenderAtomURI(), conToSendTo.getConnectionURI()});
        }
        WonMessage newWonMessage = ((ConnectionMessageBuilder)((ConnectionMessageBuilder)WonMessageBuilder.connectionMessage().sockets().sender(conToSendTo.getSocketURI()).recipient(conToSendTo.getTargetSocketURI())).forward(wonMessage).direction().fromSystem()).build();
        if (logger.isDebugEnabled()) {
            logger.debug("injecting this message: {} ", (Object)RdfUtils.toString((Dataset)Prefixer.setPrefixes((Dataset)newWonMessage.getCompleteDataset())));
        }
        this.camelWonMessageService.sendSystemMessage(newWonMessage);
    }
}

