/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.fixed;

import java.net.URI;
import javax.persistence.EntityManager;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.FixedMessageProcessor;
import won.protocol.exception.IllegalMessageForConnectionStateException;
import won.protocol.message.WonMessage;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;

@Component
@FixedMessageProcessor(direction="https://w3id.org/won/message#FromOwner", messageType="https://w3id.org/won/message#ConnectionMessage")
public class SendMessageFromOwnerProcessor
extends AbstractCamelProcessor {
    @Autowired
    EntityManager entityManager;

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        URI senderSocket = wonMessage.getSenderSocketURIRequired();
        URI recipientSocket = wonMessage.getRecipientSocketURIRequired();
        Connection con = (Connection)this.connectionRepository.findOneBySocketURIAndTargetSocketURIForUpdate(senderSocket, recipientSocket).get();
        this.entityManager.refresh((Object)con);
        if (con.getState() != ConnectionState.CONNECTED) {
            throw new IllegalMessageForConnectionStateException(con.getConnectionURI(), "CONNECTION_MESSAGE", con.getState());
        }
    }
}

