/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.util.Objects;
import java.util.Optional;
import won.node.service.nodebehaviour.ConnectionStateChange;
import won.protocol.model.ConnectionState;

public class ConnectionStateChangeBuilder {
    private Optional<ConnectionState> oldState = Optional.empty();
    private Optional<ConnectionState> newState = Optional.empty();

    public ConnectionStateChangeBuilder oldState(ConnectionState oldState) {
        Objects.nonNull(oldState);
        this.oldState = Optional.of(oldState);
        return this;
    }

    public ConnectionStateChangeBuilder newState(ConnectionState newState) {
        Objects.nonNull(newState);
        this.newState = Optional.of(newState);
        return this;
    }

    public boolean canBuild() {
        return this.oldState.isPresent() && this.newState.isPresent();
    }

    public ConnectionStateChange build() {
        if (!this.canBuild()) {
            throw new IllegalStateException("Cannot build ConnectionStateChange without a new state");
        }
        if (this.oldState.isPresent()) {
            return new ConnectionStateChange(this.oldState.get(), this.newState.get());
        }
        return new ConnectionStateChange(this.newState.get());
    }

    public String toString() {
        return "ConnectionStateChangeBuilder [oldState=" + this.oldState.map(Enum::toString).orElse("(none)") + ", newState=" + this.newState.map(Enum::toString).orElse("(none") + "]";
    }
}

