/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.processor.general.ConnectionStateChangeBuilder;
import won.node.camel.service.WonCamelHelper;
import won.node.service.persistence.ConnectionService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.model.Connection;

public class ConnectionStateChangeBuilderCamelProcessor
implements Processor {
    @Autowired
    ConnectionService connectionService;

    public void process(Exchange exchange) throws Exception {
        Optional<Connection> con;
        ConnectionStateChangeBuilder stateChangeBuilder = new ConnectionStateChangeBuilder();
        WonMessage wonMessage = WonCamelHelper.getMessageRequired(exchange);
        WonMessageType type = wonMessage.getMessageTypeRequired();
        if (type.isResponseMessage()) {
            type = wonMessage.getRespondingToMessageType();
        }
        if (type.isConnectionSpecificMessage() && (con = WonCamelHelper.getConnection(exchange, this.connectionService)).isPresent()) {
            stateChangeBuilder.oldState(con.get().getState());
        }
        exchange.getIn().setHeader("won.connectionStateChangeBuilder", (Object)stateChangeBuilder);
    }
}

