/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.net.URI;
import java.util.List;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.node.camel.processor.AbstractCamelProcessor;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.model.Atom;
import won.protocol.model.AtomState;
import won.protocol.model.ConnectionState;
import won.protocol.repository.AtomRepository;
import won.protocol.util.DataAccessUtils;

public class DeleteAtomMessageProcessor
extends AbstractCamelProcessor {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) throws Exception {
        WonMessage wonMessage = (WonMessage)exchange.getIn().getHeader("won.responseMessage");
        WonMessage focalMessage = wonMessage.getFocalMessage();
        if (focalMessage.getMessageType() == WonMessageType.SUCCESS_RESPONSE && focalMessage.getRespondingToMessageType() == WonMessageType.DELETE) {
            URI recipientAtomURI = focalMessage.getRecipientAtomURI();
            if (recipientAtomURI == null) {
                throw new WonMessageProcessingException("recipientAtomURI is not set");
            }
            Atom atom = DataAccessUtils.loadAtom((AtomRepository)this.atomRepository, (URI)recipientAtomURI);
            if (atom.getState() == AtomState.DELETED) {
                this.logger.debug("Set atom to state DELETED. atomURI:{}", (Object)recipientAtomURI);
                List conns = this.connectionRepository.findByAtomURIAndNotStateForUpdate(atom.getAtomURI(), ConnectionState.CLOSED);
                if (conns.size() > 0) {
                    this.logger.debug("Still open connections for atom. atomURI{}", (Object)recipientAtomURI);
                }
                this.messageEventRepository.deleteByParentURI(atom.getAtomURI());
                atom.resetAllAtomData();
            } else {
                this.logger.debug("DELETING atom. atomURI:{}", (Object)recipientAtomURI);
                atom.setState(AtomState.DELETED);
            }
            this.atomRepository.save((Object)atom);
        }
    }
}

