/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.exception.WonProtocolException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.message.builder.ResponseBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.message.processor.impl.SignatureAddingWonMessageProcessor;
import won.protocol.model.Connection;
import won.protocol.service.MessageRoutingInfoService;
import won.protocol.util.Prefixer;
import won.protocol.util.RdfUtils;

public class FailResponder
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    MessageRoutingInfoService messageRoutingInfoService;
    @Autowired
    ProducerTemplate producerTemplate;
    @Autowired
    private SignatureAddingWonMessageProcessor signatureAddingWonMessageProcessor;

    public void process(Exchange exchange) throws Exception {
        Exception exception = null;
        WonMessage originalMessage = null;
        try {
            originalMessage = (WonMessage)exchange.getIn().getHeader("won.message");
            if (originalMessage == null) {
                logger.warn("Could not obtain original message from camel header {} for error {}", new Object[]{"won.message", exchange.getProperty("CamelExceptionCaught")});
                logger.warn("original exception:", exchange.getProperty("CamelExceptionCaught"));
                return;
            }
            exception = (Exception)exchange.getProperty("CamelExceptionCaught");
            String errormessage = null;
            if (exception != null) {
                errormessage = exception.getClass().getSimpleName() + ": " + exception.getMessage();
            }
            if (errormessage != null) {
                errormessage = String.format("An error occurred while processing message %s (type: %s): %s", originalMessage.getMessageURI(), originalMessage.getMessageType(), errormessage);
            }
            if (exception instanceof WonProtocolException) {
                if (logger.isDebugEnabled() && exception != null) {
                    logger.debug("Caught protocol exception. Sending FailureResponse ", (Throwable)exception);
                }
            } else {
                logger.warn("Caught unexpected exception while processing WON message {} (type:{}) : {} - sending FailureResponse", new Object[]{originalMessage.getMessageURI(), originalMessage.getMessageType(), errormessage});
                logger.warn("Full stacktrace: ", (Throwable)exception);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("original message: {}", (Object)RdfUtils.toString((Dataset)Prefixer.setPrefixes((Dataset)originalMessage.getCompleteDataset())));
            }
            if (WonMessageType.FAILURE_RESPONSE == originalMessage.getMessageType()) {
                logger.info("Encountered an error processing a FailureResponse. The FailureResponse is logged at log level DEBUG. Its message URI is {}", (Object)originalMessage.getMessageURI(), (Object)exception);
                StringWriter sw = new StringWriter();
                RDFDataMgr.write((StringWriter)sw, (Dataset)Prefixer.setPrefixes((Dataset)originalMessage.getCompleteDataset()), (Lang)Lang.TRIG);
                logger.warn("FailureResponse to FailureResponse that raised the error:\n{}", (Object)sw.toString());
                return;
            }
            if (originalMessage.getMessageTypeRequired().isResponseMessage()) {
                return;
            }
            WonMessageDirection direction = WonCamelHelper.getDirectionRequired(exchange);
            ResponseBuilder responseBuilder = WonMessageBuilder.response();
            if (originalMessage.getMessageTypeRequired().isConnectionSpecificMessage()) {
                Optional<Connection> con = this.connectionService.getConnectionForMessage(originalMessage, WonCamelHelper.getDirectionRequired(exchange));
                if (con.isPresent()) {
                    responseBuilder.fromConnection(con.get().getConnectionURI());
                }
            } else if (originalMessage.getMessageTypeRequired().isAtomSpecificMessage()) {
                responseBuilder.fromAtom(originalMessage.getAtomURIRequired());
            }
            WonMessage responseMessage = ((ResponseBuilder)responseBuilder.respondingToMessage(originalMessage, WonCamelHelper.getDirectionRequired(exchange)).failure().content().text(errormessage)).build();
            responseMessage = this.signatureAddingWonMessageProcessor.signWithDefaultKey(responseMessage);
            WonCamelHelper.putResponse(exchange, responseMessage);
            WonCamelHelper.putMessageToSend(exchange, responseMessage);
            URI atom = (URI)this.messageRoutingInfoService.recipientAtom(responseMessage).orElseThrow(() -> new IllegalArgumentException("Cannot dertermine recipient atom for response"));
            Optional senderNode = this.messageRoutingInfoService.senderNode(responseMessage);
            URI recipientNode = (URI)this.messageRoutingInfoService.recipientNode(responseMessage).orElseThrow(() -> new IllegalArgumentException("Cannot dertermine node for response"));
            if (senderNode.isPresent()) {
                WonCamelHelper.putSenderNodeURI(exchange, (URI)senderNode.get());
            }
            WonCamelHelper.putRecipientNodeURI(exchange, recipientNode);
            WonCamelHelper.putRecipientAtomURI(exchange, atom);
            if (direction.isFromExternal()) {
                this.messagingService.send(exchange, "direct:sendToNode");
            } else if (direction.isFromOwner()) {
                this.messagingService.send(exchange, "direct:sendToOwner");
            }
        }
        catch (Throwable t) {
            logger.warn("Error in failure response handling!");
            URI originalMessageURI = null;
            try {
                originalMessageURI = originalMessage == null ? null : originalMessage.getMessageURI();
            }
            catch (Exception e) {
                logger.error("Error getting message URI from WonMessage");
            }
            if (exception != null && exception.getClass() != null) {
                logger.warn(String.format("Could not send FailureResponse for original Exception %s (message: %s) that occurred while processing message %s.", exception.getClass().getSimpleName(), exception.getMessage(), originalMessageURI), t);
                logger.warn("original error: ", (Throwable)exception);
            }
            logger.warn(String.format("Could not send FailureResponse to original message %s.", originalMessageURI), t);
            logger.warn("original error: ", (Throwable)exception);
        }
    }
}

