/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.service.WonCamelHelper;
import won.node.service.persistence.MessageService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.model.Atom;
import won.protocol.repository.AtomMessageContainerRepository;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.ConnectionMessageContainerRepository;
import won.protocol.repository.ConnectionRepository;

public class LockMessageParentWonMessageProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    ConnectionRepository connectionRepository;
    @Autowired
    AtomRepository atomRepository;
    @Autowired
    ConnectionMessageContainerRepository connectionMessageContainerRepository;
    @Autowired
    AtomMessageContainerRepository atomMessageContainerRepository;
    @Autowired
    MessageService messageService;
    @Autowired
    EntityManager entityManager;

    public void process(Exchange exchange) throws Exception {
        WonMessage message = WonCamelHelper.getMessageRequired(exchange);
        WonMessageDirection direction = WonCamelHelper.getDirectionRequired(exchange);
        logger.debug("trying to lock parent of {} message {} {}", new Object[]{message.getMessageType(), message.getMessageURI(), direction});
        try {
            this.lockParent(message, WonCamelHelper.getDirectionRequired(exchange));
        }
        catch (Exception e) {
            URI messageUri;
            try {
                messageUri = message.getMessageURI();
            }
            catch (Exception e1) {
                logger.error("Error getting messageURI from WonMessage", (Throwable)e);
                messageUri = null;
            }
            logger.error("Error locking parent of WonMessage with uri {}", (Object)messageUri, (Object)e);
        }
    }

    private void lockParent(WonMessage message, WonMessageDirection direction) {
        WonMessageType type;
        WonMessageType wonMessageType = type = message.getMessageTypeRequired().isResponseMessage() ? message.getRespondingToMessageTypeRequired() : message.getMessageTypeRequired();
        if (type.isConnectionSpecificMessage()) {
            logger.debug("Attempting to lock connection for message {} {}", (Object)message.getMessageURI(), (Object)direction);
            Optional<URI> conURI = this.messageService.getConnectionofMessage(message, direction);
            if (conURI.isPresent()) {
                logger.debug("Locking connection {} for message {} {}", new Object[]{conURI.get(), message.getMessageURI(), direction});
                Optional con = this.connectionRepository.findOneByConnectionURIForUpdate(conURI.get());
                if (con.isPresent()) {
                    this.entityManager.refresh(con.get());
                    logger.debug("Locked connection {} for message {} {}", new Object[]{conURI.get(), message.getMessageURI(), direction});
                    logger.debug("connection: {}", con.get());
                    return;
                }
                logger.debug("Did not lock connection {} for message {} {}", new Object[]{conURI.get(), message.getMessageURI(), direction});
            } else {
                logger.debug("Did not find connection to lock for message {} {}", (Object)message.getMessageURI(), (Object)direction);
            }
        } else {
            logger.debug("Not attempting to lock connection for message {} {}", (Object)message.getMessageURI(), (Object)direction);
        }
        logger.debug("Attempting to lock atom for message {}", (Object)message.getMessageURI());
        Optional<URI> atomURI = this.messageService.getAtomOfMessage(message, direction);
        if (atomURI.isPresent()) {
            Optional atom = this.atomRepository.findOneByAtomURIForUpdate(atomURI.get());
            if (atom.isPresent()) {
                this.entityManager.refresh(atom.get());
                logger.debug("Locked atom {} for message {} {}", new Object[]{((Atom)atom.get()).getAtomURI(), message.getMessageURI(), direction});
            } else {
                logger.debug("Did not find atom {} to lock for message {} {}", new Object[]{atomURI.get(), message.getMessageURI(), direction});
            }
        } else {
            logger.debug("Did not find atom to lock for message {} {}", (Object)message.getMessageURI(), (Object)direction);
        }
    }
}

