/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StopWatch;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;
import won.protocol.model.MessageContainer;
import won.protocol.repository.MessageContainerRepository;
import won.protocol.util.LogMarkers;
import won.protocol.vocabulary.WONMSG;

public class MessageReferencer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MessageContainerRepository messageContainerRepository;

    public WonMessage addMessageReferences(WonMessage message, URI parentURI) throws WonMessageProcessingException {
        StopWatch sw = new StopWatch();
        sw.start();
        if (message.getMessageTypeRequired().isSuccessResponse() && (Objects.equals(message.getConnectionURI(), parentURI) || Objects.equals(message.getAtomURI(), parentURI))) {
            Optional container;
            if (logger.isDebugEnabled()) {
                logger.debug("Referencing unconfirmed messages in {} from message {}", (Object)parentURI, (Object)message.toShortStringForDebug());
            }
            if ((container = this.messageContainerRepository.findOneByParentUri(parentURI)).isPresent()) {
                message.addMessagePropertiesURI(WONMSG.previousMessage, (Collection)((MessageContainer)container.get()).getUnconfirmedAndIncrementAndCleanup());
                if (logger.isDebugEnabled()) {
                    logger.debug("Added {} references to message {}: {}", new Object[]{((MessageContainer)container.get()).getUnconfirmedCount(), message.toShortStringForDebug(), ((MessageContainer)container.get()).peekAtUnconfirmed()});
                }
            } else {
                logger.debug("No unconfirmed messages found");
            }
        }
        sw.stop();
        logger.debug(LogMarkers.TIMING, "adding unconfirmed took {} millis", (Object)sw.getLastTaskTimeMillis());
        return message;
    }
}

