/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import won.node.camel.service.WonCamelHelper;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;

public class MessageTypeSlipComputer
implements InitializingBean,
ApplicationContextAware,
Expression {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    HashMap<String, Object> fixedMessageProcessorsMap;
    private ApplicationContext applicationContext;
    private Class annotationClazz;
    private boolean allowNoMatchingProcessor = false;

    public MessageTypeSlipComputer(String annotationClazzName) throws ClassNotFoundException {
        this.annotationClazz = Class.forName(annotationClazzName);
    }

    public MessageTypeSlipComputer(String annotationClazzName, boolean allowNoMatchingProcessor) throws ClassNotFoundException {
        this(annotationClazzName);
        this.allowNoMatchingProcessor = allowNoMatchingProcessor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.fixedMessageProcessorsMap = (HashMap)this.applicationContext.getBeansWithAnnotation(this.annotationClazz);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        WonMessage message = WonCamelHelper.getMessageRequired(exchange);
        String slip = "";
        URI messageType = WonCamelHelper.getMessageTypeRequired(exchange).getURI();
        URI direction = WonCamelHelper.getDirectionRequired(exchange).getURI();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received {}", (Object)message.toShortStringForDebug());
        }
        try {
            slip = this.computeMessageTypeSlip(messageType, direction);
            if (slip == null || slip.isEmpty()) {
                return null;
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return type.cast(slip);
    }

    private String computeMessageTypeSlip(URI messageType, URI direction) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Iterator<Map.Entry<String, Object>> iter = this.fixedMessageProcessorsMap.entrySet().iterator();
        StringBuilder slipBuilder = new StringBuilder();
        while (iter.hasNext()) {
            Map.Entry<String, Object> pair = iter.next();
            Processor wonMessageProcessor = (Processor)pair.getValue();
            Object annotation = AopUtils.getTargetClass((Object)wonMessageProcessor).getAnnotation(this.annotationClazz);
            if (!this.matches((Annotation)annotation, messageType, direction, null)) continue;
            slipBuilder.append("bean:").append(pair.getKey().toString()).append("?method=process,");
        }
        String slip = slipBuilder.toString();
        if (!slip.isEmpty()) {
            return slip.substring(0, slip.length() - 1);
        }
        if (this.allowNoMatchingProcessor) {
            return null;
        }
        this.logger.debug("unexpected combination of messageType {} and direction {} encountered - this causes an exception,which triggers a FailureResponse", (Object)messageType, (Object)direction);
        throw new WonMessageProcessingException(String.format("unexpected combination of messageType %s and direction %s encountered", messageType, direction));
    }

    private boolean matches(Annotation annotation, URI messageType, URI direction, URI socketType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (annotation == null || messageType == null || direction == null) {
            return false;
        }
        if (!this.annotationFeatureMatches(annotation, messageType.toString(), "messageType")) {
            return false;
        }
        if (!this.annotationFeatureMatches(annotation, direction.toString(), "direction")) {
            return false;
        }
        return socketType == null || this.annotationFeatureMatches(annotation, socketType.toString(), "socketType");
    }

    private boolean annotationFeatureMatches(Annotation annotation, String expected, String featureName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object actualValue = annotation.annotationType().getDeclaredMethod(featureName, new Class[0]).invoke((Object)annotation, new Object[0]);
        return "ANY".equals(actualValue) || expected.equals(actualValue);
    }
}

