/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.service.WonCamelHelper;
import won.node.service.persistence.MessageService;
import won.protocol.message.WonMessage;

public class ResponsePersistingProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    MessageService messageService;

    public void process(Exchange exchange) throws Exception {
        WonMessage message = WonCamelHelper.getResponseRequired(exchange);
        URI parentURI = WonCamelHelper.getParentURIRequired(exchange);
        if (logger.isDebugEnabled()) {
            logger.debug("storing response message {}", (Object)message.toStringForDebug(false));
        }
        this.messageService.saveMessage(message, parentURI);
    }
}

