/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.net.URI;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.service.MessageRoutingInfoService;

public class ResponseRoutingInfoExtractor
implements Processor {
    @Autowired
    MessageRoutingInfoService messageRoutingInfoService;

    public void process(Exchange exchange) throws Exception {
        WonMessage response = WonCamelHelper.getResponseRequired(exchange);
        Objects.requireNonNull(response);
        URI atom = (URI)this.messageRoutingInfoService.recipientAtom(response).orElseThrow(() -> new IllegalArgumentException("Cannot dertermine recipient atom for response message " + response.getMessageURI()));
        URI senderNode = (URI)this.messageRoutingInfoService.senderNode(response).orElseThrow(() -> new IllegalArgumentException("Cannot dertermine sender node for response message " + response.getMessageURI()));
        URI recipientNode = (URI)this.messageRoutingInfoService.recipientNode(response).orElseThrow(() -> new IllegalArgumentException("Cannot dertermine recipient node for response message " + response.getMessageURI()));
        WonCamelHelper.putRecipientAtomURI(exchange, atom);
        WonCamelHelper.putSenderNodeURI(exchange, senderNode);
        WonCamelHelper.putRecipientNodeURI(exchange, recipientNode);
    }
}

