/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.net.URI;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.service.MessageRoutingInfoService;

public class RoutingInfoExtractor
implements Processor {
    @Autowired
    MessageRoutingInfoService messageRoutingInfoService;

    public void process(Exchange exchange) throws Exception {
        WonMessage message = WonCamelHelper.getMessageRequired(exchange);
        URI atom = (URI)this.messageRoutingInfoService.recipientAtom(message).orElseThrow(() -> new IllegalArgumentException("Cannot dertermine recipient atom for message " + message.getMessageURI()));
        Optional senderNode = this.messageRoutingInfoService.senderNode(message);
        URI recipientNode = (URI)this.messageRoutingInfoService.recipientNode(message).orElseThrow(() -> new IllegalArgumentException("Cannot dertermine node for response message " + message.getMessageURI()));
        if (senderNode.isPresent()) {
            WonCamelHelper.putSenderNodeURI(exchange, (URI)senderNode.get());
        }
        WonCamelHelper.putRecipientNodeURI(exchange, recipientNode);
        WonCamelHelper.putRecipientAtomURI(exchange, atom);
    }
}

