/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.processor.general.ConnectionStateChangeBuilder;
import won.node.camel.service.WonCamelHelper;
import won.node.service.nodebehaviour.ConnectionStateChange;
import won.node.service.nodebehaviour.DataDerivationService;
import won.node.service.persistence.AtomService;
import won.node.service.persistence.ConnectionService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.model.Atom;
import won.protocol.model.Connection;

public class SocketDerivationProcessor
implements Processor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DataDerivationService dataDerivationService;
    @Autowired
    ConnectionService connectionService;
    @Autowired
    AtomService atomService;

    public void process(Exchange exchange) throws Exception {
        WonMessage wonMessage = WonCamelHelper.getMessageRequired(exchange);
        if (!wonMessage.getMessageTypeRequired().isConnectionSpecificMessage()) {
            return;
        }
        WonMessageDirection direction = WonCamelHelper.getDirectionRequired(exchange);
        ConnectionStateChangeBuilder stateChangeBuilder = (ConnectionStateChangeBuilder)exchange.getIn().getHeader("won.connectionStateChangeBuilder");
        if (stateChangeBuilder == null) {
            throw new IllegalStateException("expecting to find a ConnectionStateBuilder in 'in' header 'won.connectionStateChangeBuilder'");
        }
        Optional<Connection> con = WonCamelHelper.getConnection(exchange, this.connectionService);
        if (con.isPresent()) {
            stateChangeBuilder.newState(con.get().getState());
            if (stateChangeBuilder.canBuild()) {
                ConnectionStateChange connectionStateChange = stateChangeBuilder.build();
                if (!con.isPresent()) {
                    this.logger.warn("Cannot derive data: no connection found");
                }
                Atom atom = this.atomService.getAtomRequired(con.get().getAtomURI());
                this.dataDerivationService.deriveDataForStateChange(connectionStateChange, atom, con.get());
            }
        }
    }
}

