/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.net.URI;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.service.WonCamelHelper;
import won.node.service.persistence.SocketService;
import won.protocol.exception.NoSuchSocketException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.model.Socket;

public class SocketTypeExtractor
implements Processor {
    @Autowired
    SocketService socketService;

    public void process(Exchange exchange) throws Exception {
        WonMessage msg = WonCamelHelper.getMessageRequired(exchange);
        WonMessageDirection direction = WonCamelHelper.getDirectionRequired(exchange);
        Optional<Object> socketURI = Optional.empty();
        socketURI = direction.isFromExternal() ? Optional.ofNullable(msg.getRecipientSocketURI()) : Optional.ofNullable(msg.getSenderSocketURI());
        if (socketURI.isPresent()) {
            Optional<Socket> socket = this.socketService.getSocket((URI)socketURI.get());
            if (socket.isPresent()) {
                WonCamelHelper.putSocketTypeURI(exchange, socket.get().getTypeURI());
            } else {
                throw new NoSuchSocketException((URI)socketURI.get());
            }
        }
    }
}

