/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import won.node.camel.processor.annotation.DefaultSocketMessageProcessor;
import won.node.camel.processor.annotation.SocketMessageProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;

public class SocketTypeSlipComputer
implements InitializingBean,
ApplicationContextAware,
Expression {
    private HashMap<String, Object> socketMessageProcessorsMap;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.socketMessageProcessorsMap = (HashMap)this.applicationContext.getBeansWithAnnotation(SocketMessageProcessor.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        WonMessage message = WonCamelHelper.getMessageRequired(exchange);
        assert (message != null) : "wonMessage header must not be null";
        WonMessageType messageType = WonCamelHelper.getMessageTypeRequired(exchange);
        assert (messageType != null) : "messageType header must not be null";
        WonMessageDirection direction = WonCamelHelper.getDirectionRequired(exchange);
        if (direction.isFromSystem()) {
            direction = WonMessageDirection.FROM_OWNER;
        }
        assert (direction != null) : "direction header must not be null";
        URI socketType = WonCamelHelper.getSocketTypeURIRequired(exchange);
        String slip = "bean:" + this.computeSocketSlip(messageType.getURI(), socketType, direction.getURI()) + "?method=process";
        return type.cast(slip);
    }

    private String computeSocketSlip(URI messageType, URI socketType, URI direction) {
        Optional<String> processorName;
        if (socketType != null && (processorName = this.socketMessageProcessorsMap.entrySet().stream().filter(entry -> {
            Object socket = entry.getValue();
            SocketMessageProcessor annotation = AopUtils.getTargetClass(socket).getAnnotation(SocketMessageProcessor.class);
            return this.matches(annotation, messageType, direction, socketType);
        }).findFirst().map(Map.Entry::getKey)).isPresent()) {
            return processorName.get();
        }
        processorName = this.socketMessageProcessorsMap.entrySet().stream().filter(entry -> {
            Object socket = entry.getValue();
            DefaultSocketMessageProcessor annotation = AopUtils.getTargetClass(socket).getAnnotation(DefaultSocketMessageProcessor.class);
            return this.matches(annotation, messageType, direction, null);
        }).findFirst().map(Map.Entry::getKey);
        if (processorName.isPresent()) {
            return processorName.get();
        }
        throw new WonMessageProcessingException(String.format("unexpected combination of messageType %s, socketType %s and direction %s encountered", messageType, socketType, direction));
    }

    private boolean matches(Annotation annotation, URI messageType, URI direction, URI socketType) {
        if (annotation == null || messageType == null || direction == null) {
            return false;
        }
        try {
            if (this.annotationFeatureMismatch(annotation, messageType.toString(), "messageType") || this.annotationFeatureMismatch(annotation, direction.toString(), "direction")) {
                return false;
            }
            if (socketType != null && this.annotationFeatureMismatch(annotation, socketType.toString(), "socketType")) {
                return false;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean annotationFeatureMismatch(Annotation annotation, String expected, String featureName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return !expected.equals(annotation.annotationType().getDeclaredMethod(featureName, new Class[0]).invoke((Object)annotation, new Object[0]));
    }
}

