/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.general.MessageReferencer;
import won.node.camel.service.WonCamelHelper;
import won.node.service.persistence.ConnectionService;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.ResponseBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.message.processor.impl.SignatureAddingWonMessageProcessor;
import won.protocol.model.Connection;

public class SuccessResponder
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MessageReferencer messageReferencer;
    @Autowired
    private SignatureAddingWonMessageProcessor signatureAddingWonMessageProcessor;
    @Autowired
    private ConnectionService connectionService;

    public void process(Exchange exchange) throws Exception {
        WonMessage originalMessage = WonCamelHelper.getMessageRequired(exchange);
        if (originalMessage.getMessageTypeRequired().isResponseMessage()) {
            return;
        }
        ResponseBuilder responseBuilder = WonMessageBuilder.response();
        if (originalMessage.getMessageTypeRequired().isConnectionSpecificMessage()) {
            Optional<Connection> con = this.connectionService.getConnectionForMessage(originalMessage, WonCamelHelper.getDirectionRequired(exchange));
            if (con.isPresent()) {
                responseBuilder.fromConnection(con.get().getConnectionURI());
            }
        } else if (originalMessage.getMessageTypeRequired().isAtomSpecificMessage()) {
            responseBuilder.fromAtom(originalMessage.getAtomURIRequired());
        }
        WonMessage responseMessage = responseBuilder.respondingToMessage(originalMessage, WonCamelHelper.getDirectionRequired(exchange)).success().build();
        this.messageReferencer.addMessageReferences(responseMessage, WonCamelHelper.getParentURIRequired(exchange));
        responseMessage = this.signatureAddingWonMessageProcessor.signWithDefaultKey(responseMessage);
        exchange.getIn().setHeader("won.responseMessage", (Object)responseMessage);
    }
}

