/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.net.URI;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.service.WonCamelHelper;
import won.protocol.jms.AtomProtocolCommunicationService;
import won.protocol.jms.MessagingService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.service.MessageRoutingInfoService;

public class ToNodeSender
implements Processor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    MessagingService messagingService;
    @Autowired
    MessageRoutingInfoService messageRoutingInfoService;
    @Autowired
    private AtomProtocolCommunicationService atomProtocolCommunicationService;
    @Autowired
    private CamelContext camelContext;

    public void process(Exchange exchange) throws Exception {
        this.logger.debug("processing message for sending to remote node");
        WonMessage msg = WonCamelHelper.getMessageToSendRequired(exchange);
        Optional senderNode = this.messageRoutingInfoService.senderNode(msg);
        Optional recipientNode = this.messageRoutingInfoService.recipientNode(msg);
        if (!senderNode.isPresent() || !recipientNode.isPresent()) {
            this.logger.warn("Cannot send message {} to remote node: could not determine sender/recipient node", (Object)msg.getMessageURI());
        }
        if (((URI)senderNode.get()).equals(recipientNode.get())) {
            DefaultExchange newExchangeFromExternal = new DefaultExchange(this.camelContext);
            WonCamelHelper.putMessage((Exchange)newExchangeFromExternal, msg);
            WonCamelHelper.putDirection((Exchange)newExchangeFromExternal, WonMessageDirection.FROM_EXTERNAL);
            WonCamelHelper.putMessageType((Exchange)newExchangeFromExternal, msg.getMessageType());
            this.messagingService.send((Exchange)newExchangeFromExternal, "seda:msgFromExternal");
            WonCamelHelper.removeMessageToSend(exchange);
            return;
        }
        this.atomProtocolCommunicationService.configureCamelEndpoint((URI)recipientNode.get());
        String ep = this.atomProtocolCommunicationService.getProtocolCamelConfigurator().getEndpoint((URI)recipientNode.get());
        String msgBody = (String)exchange.getIn().getBody();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending message to node {}: {}", (Object)recipientNode, (Object)msg.toStringForDebug(true));
        }
        this.messagingService.sendInOnlyMessage(null, null, (Object)msgBody, ep);
        WonCamelHelper.removeMessageToSend(exchange);
    }
}

