/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.service.WonCamelHelper;
import won.node.service.persistence.OwnerManagementService;
import won.protocol.jms.MessagingService;
import won.protocol.message.WonMessage;
import won.protocol.model.Atom;
import won.protocol.model.OwnerApplication;
import won.protocol.repository.OwnerApplicationRepository;

public class ToOwnerSender
extends AbstractCamelProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OwnerManagementService ownerManagementService;
    @Autowired
    private OwnerApplicationRepository ownerApplicationRepository;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private MessagingService messagingService;

    public void process(Exchange exchange) throws Exception {
        WonMessage msg = WonCamelHelper.getMessageToSendRequired(exchange);
        Objects.requireNonNull(msg);
        URI recipientAtom = WonCamelHelper.getRecipientAtomURIRequired(exchange);
        Optional<Atom> atom = this.atomService.getAtom(recipientAtom);
        List<OwnerApplication> ownerApps = this.getOwnerApplications(msg, atom, WonCamelHelper.getOwnerApplicationId(exchange));
        this.logger.debug("number of registered owner applications: {}", (Object)(ownerApps == null ? 0 : ownerApps.size()));
        List queueNames = ownerApps.stream().map(app -> this.getQueueName((OwnerApplication)app)).collect(Collectors.toList());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending message to owner(s) {}: {}", (Object)Arrays.toString(queueNames.toArray()), (Object)msg.toStringForDebug(true));
        }
        DefaultExchange exchangeToOwners = new DefaultExchange(this.camelContext);
        WonCamelHelper.putMessageIntoBody((Exchange)exchangeToOwners, msg);
        exchangeToOwners.getIn().setHeader("won.ownerApplicationIds", queueNames);
        this.messagingService.send((Exchange)exchangeToOwners, "direct:sendToOwnerApplications");
        WonCamelHelper.removeMessageToSend(exchange);
    }

    private String getQueueName(OwnerApplication ownerapp) {
        this.logger.debug("ownerApplicationID: {}", (Object)ownerapp.getOwnerApplicationId());
        return this.ownerManagementService.getEndpointForMessage("wonMessage", ownerapp.getOwnerApplicationId());
    }

    private List<OwnerApplication> getOwnerApplications(WonMessage msg, Optional<Atom> atom, Optional<String> fallbackOwnerApplicationId) {
        Objects.requireNonNull(msg);
        Objects.requireNonNull(atom);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("about to send this message to registered owner apps:" + msg.toStringForDebug(true));
        }
        ArrayList<OwnerApplication> ownerApplications = new ArrayList<OwnerApplication>();
        if (atom.isPresent()) {
            ownerApplications.addAll(atom.get().getAuthorizedApplications());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Atom to send the message {} to: {}", (Object)msg.getMessageURI(), (Object)atom.get().getAtomURI());
                this.logger.debug("Found these ownerapplicationids for message {} : {}", (Object)msg.getMessageURI(), ownerApplications);
            }
        }
        if (ownerApplications.isEmpty() && fallbackOwnerApplicationId.isPresent()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using this ownerapplicationid as fallback for message {} : {}", (Object)msg.getMessageURI(), (Object)fallbackOwnerApplicationId.get());
            }
            this.ownerApplicationRepository.findOneByOwnerApplicationId(fallbackOwnerApplicationId.get()).ifPresent(x -> ownerApplications.add((OwnerApplication)x));
        }
        return ownerApplications;
    }
}

