/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.general;

import java.net.URI;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.IsoMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StopWatch;
import won.node.camel.service.WonCamelHelper;
import won.node.service.persistence.AtomService;
import won.node.service.persistence.MessageService;
import won.protocol.exception.UriAlreadyInUseException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.exception.EventAlreadyProcessedException;
import won.protocol.model.Atom;
import won.protocol.model.MessageEvent;
import won.protocol.util.LogMarkers;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;

public class UriAlreadyUsedCheckingWonMessageProcessor
implements Processor {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MessageService messageService;
    @Autowired
    protected AtomService atomService;

    public void process(Exchange exchange) throws Exception {
        StopWatch sw = new StopWatch();
        sw.start();
        WonMessage message = WonCamelHelper.getMessageRequired(exchange);
        WonMessageDirection direction = WonCamelHelper.getDirectionRequired(exchange);
        Optional<URI> parentUri = WonCamelHelper.getParentURI(exchange);
        if (!parentUri.isPresent()) {
            parentUri = this.messageService.getParentofMessage(message, direction);
        }
        if (parentUri.isPresent()) {
            this.checkEventURI(message, parentUri.get());
        }
        this.checkAtomURI(message);
        sw.stop();
        this.logger.debug(LogMarkers.TIMING, "URI in use check for message {} took {} milllis", (Object)message.getMessageURIRequired(), (Object)sw.getLastTaskTimeMillis());
    }

    private void checkAtomURI(WonMessage message) {
        if (message.getMessageType() == WonMessageType.CREATE_ATOM) {
            URI atomURI = WonRdfUtils.AtomUtils.getAtomURI((Dataset)message.getCompleteDataset());
            Optional<Atom> atom = this.atomService.getAtom(atomURI);
            if (!atom.isPresent()) {
                return;
            }
            throw new UriAlreadyInUseException(message.getSenderAtomURI().toString());
        }
    }

    private void checkEventURI(WonMessage message, URI parentURI) {
        Optional<MessageEvent> event = this.messageService.getMessage(message.getMessageURI(), parentURI);
        if (!event.isPresent()) {
            return;
        }
        if (this.isDuplicateMessage(message, event.get())) {
            throw new EventAlreadyProcessedException(message.getMessageURI().toString());
        }
        throw new UriAlreadyInUseException(message.getMessageURI().toString());
    }

    private boolean isDuplicateMessage(WonMessage message, MessageEvent event) {
        Dataset processedDataset = event.getDatasetHolder().getDataset();
        WonMessage processedMessage = WonMessage.of((Dataset)processedDataset);
        boolean sameEnvelope = this.hasSameEnvelopeData(processedMessage, message);
        boolean sameContent = this.hasSameContent(processedMessage, message);
        return sameEnvelope && sameContent;
    }

    private boolean hasSameContent(WonMessage processedMessage, WonMessage message) {
        Dataset messageContent = message.getMessageContent();
        Dataset processedContent = processedMessage.getMessageContent();
        for (String name : RdfUtils.getModelNames((Dataset)processedContent)) {
            Model model;
            if (!WonRdfUtils.SignatureUtils.isSignatureGraph((String)name, (Model)(model = processedContent.getNamedModel(name))) || RdfUtils.getModelNames((Dataset)messageContent).contains(name)) continue;
            processedContent.removeNamedModel(name);
        }
        return IsoMatcher.isomorphic((DatasetGraph)processedContent.asDatasetGraph(), (DatasetGraph)messageContent.asDatasetGraph());
    }

    private boolean hasSameEnvelopeData(WonMessage processedMessage, WonMessage message) {
        return this.equalsOrBothNull(processedMessage.getSenderAtomURI(), message.getSenderAtomURI()) && this.equalsOrBothNull(processedMessage.getRecipientAtomURI(), message.getRecipientAtomURI()) && this.equalsOrBothNull(processedMessage.getSenderNodeURI(), message.getSenderNodeURI()) && this.equalsOrBothNull(processedMessage.getRecipientNodeURI(), message.getRecipientNodeURI()) && this.equalsOrBothNull(processedMessage.getRespondingToMessageURI(), message.getRespondingToMessageURI()) && processedMessage.getContentGraphURIs().containsAll(message.getContentGraphURIs()) && this.equalsOrBothNull(processedMessage.getMessageType(), message.getMessageType()) && this.equalsOrBothNull(processedMessage.getHintTargetAtomURI(), message.getHintTargetAtomURI()) && this.equalsOrBothNull(processedMessage.getHintTargetSocketURI(), message.getHintTargetSocketURI()) && this.equalsOrBothNull(processedMessage.getHintScore(), message.getHintScore()) && this.equalsOrBothNull(processedMessage.getEnvelopeType(), message.getEnvelopeType());
    }

    private boolean equalsOrBothNull(Object uri1, Object uri2) {
        return uri1 == null && uri2 == null || uri1.equals(uri2);
    }
}

